/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.gui.wizards.ProcedureParameterDefinitionWizard;
import pl.mpak.orbada.firebird.services.FirebirdTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateProcedureWizard
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private Database database;
    private ProcedureParameterDefinitionWizard parametrDefinition;
    private ProcedureParameterDefinitionWizard returnsDefinition;
    private Template template;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTabbedPane tab;
    private TextField textDescription;
    private TextField textName;

    public CreateProcedureWizard(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.parametrDefinition = new ProcedureParameterDefinitionWizard(this.database, true);
        this.returnsDefinition = new ProcedureParameterDefinitionWizard(this.database, false);
        this.tab.addTab(this.stringManager.getString("CreateProcedureWizard-input-parameters"), (Component)((Object)this.parametrDefinition));
        this.tab.addTab(this.stringManager.getString("CreateProcedureWizard-return-parameters"), (Component)((Object)this.returnsDefinition));
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(FirebirdTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(FirebirdTemplatesSettingsProvider.setProcedure, "firebird-procedure"));
        this.parametrDefinition.wizardShow();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateProcedureWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateProcedureWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String returnValues = this.returnsDefinition.getSqlCode();
        if (this.template == null) {
            return "CREATE PROCEDURE " + this.textName.getText() + " " + this.parametrDefinition.getSqlCode() + ("".equals(returnValues) ? "" : " RETURNS " + returnValues) + " AS \n" + "-- " + this.textDescription.getText() + "\n" + "BEGIN\n" + "  SUSPEND;\n" + "END\n" + "/";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", this.textName.getText());
        map.put("&parameters", this.parametrDefinition.getSqlCode());
        map.put("&description", this.textDescription.getText());
        map.put("&returns", "".equals(returnValues) ? "" : " RETURNS " + returnValues);
        map.put("&body", "  SUSPEND;");
        return this.template.expand(map) + "\n/";
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.tab = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel4 = new JLabel();
        this.textDescription = new TextField();
        this.tab.setFocusable(false);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("procedure-name-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("description-dd"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textName, -2, 222, -2).addComponent((Component)this.textDescription, -1, 410, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textDescription, -2, -1, -2)).addContainerGap(196, Short.MAX_VALUE)));
        this.tab.addTab(this.stringManager.getString("general"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 580, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }
}

