/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.services.FirebirdTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.gui.util.TableComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateTriggerWizard
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private Database database;
    private String tableName;
    private Template template;
    private JRadioButton checkAfter;
    private JRadioButton checkBefore;
    private JRadioButton checkDelete;
    private JCheckBox checkInactive;
    private JRadioButton checkInsert;
    private JRadioButton checkUpdate;
    private JComboBox comboTables;
    private ButtonGroup groupBA;
    private ButtonGroup groupIUD;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private TextField textDescription;
    private TextField textName;
    private TextField textPosition;

    public CreateTriggerWizard(Database database, String tableName) {
        this.database = database;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboTables.setModel(new TableComboBoxModel(this.database));
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(FirebirdTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(FirebirdTemplatesSettingsProvider.setTrigger, "firebird-trigger"));
        ((TableComboBoxModel)this.comboTables.getModel()).change(null);
        ((TableComboBoxModel)this.comboTables.getModel()).select(this.tableName, this.comboTables);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateTriggerWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateTriggerWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        this.tableName = SQLUtil.createSqlName((String)this.comboTables.getSelectedItem().toString());
        String idu = "";
        if (this.checkInsert.isSelected()) {
            idu = idu + " INSERT";
        } else if (this.checkDelete.isSelected()) {
            idu = idu + " DELETE";
        } else if (this.checkUpdate.isSelected()) {
            idu = idu + " UPDATE";
        }
        String type = "  " + (this.checkBefore.isSelected() ? "BEFORE" : "AFTER") + idu + ("".equals(this.textPosition.getText()) ? "" : " POSITION " + this.textPosition.getText());
        if (this.template == null) {
            return "CREATE TRIGGER " + this.textName.getText() + " FOR " + this.tableName + "\n" + (this.checkInactive.isSelected() ? "  INACTIVE\n" : "") + type + " AS\n" + ("".equals(this.textDescription.getText()) ? "" : "/* " + this.textDescription.getText() + " */\n") + "BEGIN\n" + "END;";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", this.textName.getText());
        map.put("&tablename", this.tableName);
        map.put("&type", type);
        map.put("&body", "");
        map.put("&description", this.textDescription.getText());
        return this.template.expand(map);
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.groupBA = new ButtonGroup();
        this.groupIUD = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.comboTables = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.checkInactive = new JCheckBox();
        this.checkBefore = new JRadioButton();
        this.checkAfter = new JRadioButton();
        this.checkInsert = new JRadioButton();
        this.checkUpdate = new JRadioButton();
        this.checkDelete = new JRadioButton();
        this.textPosition = new TextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.textDescription = new TextField();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-name-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("trigger-name-dd"));
        this.textName.setText("_TRG");
        this.checkInactive.setText(this.stringManager.getString("inactive"));
        this.groupBA.add(this.checkBefore);
        this.checkBefore.setSelected(true);
        this.checkBefore.setText("BEFORE");
        this.groupBA.add(this.checkAfter);
        this.checkAfter.setText("AFTER");
        this.groupIUD.add(this.checkInsert);
        this.checkInsert.setSelected(true);
        this.checkInsert.setText("INSERT");
        this.groupIUD.add(this.checkUpdate);
        this.checkUpdate.setText("UPDATE");
        this.groupIUD.add(this.checkDelete);
        this.checkDelete.setText("DELETE");
        this.textPosition.setText("0");
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("order-dd"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("description-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTables, 0, 274, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, -2, 127, -2).addComponent(this.jLabel3, -2, 127, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkInactive).addComponent((Component)this.textName, -1, 274, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.checkBefore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkAfter)).addGroup(layout.createSequentialGroup().addComponent(this.checkInsert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDelete)).addComponent((Component)this.textPosition, -2, 90, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textDescription, -1, 274, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboTables, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkInactive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBefore).addComponent(this.checkAfter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkInsert).addComponent(this.checkUpdate).addComponent(this.checkDelete)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.textPosition, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.textDescription, -2, -1, -2)).addContainerGap(22, Short.MAX_VALUE)));
    }
}

