/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class GrantProcedurePrivilegesWizard
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private Database database;
    private String objectName;
    private JCheckBox checkGrantOption;
    private ComboBox comboObjects;
    private ComboBox comboProcedures;
    private ComboBox comboTriggers;
    private ComboBox comboUsers;
    private ComboBox comboViews;
    private ButtonGroup groupObject;
    private JLabel jLabel5;
    private JRadioButton radioProcedure;
    private JRadioButton radioTrigger;
    private JRadioButton radioUser;
    private JRadioButton radioView;

    public GrantProcedurePrivilegesWizard(Database database, String objectName) {
        this.database = database;
        this.objectName = objectName;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardShow() {
        Query query = this.database.createQuery();
        try {
            query.open(Sql.getProcedureNameList());
            this.comboObjects.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            this.comboObjects.setSelectedItem((Object)this.objectName);
            query.open(Sql.getUserNameList());
            this.comboUsers.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            query.open(Sql.getViewNameList());
            this.comboViews.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            query.open(Sql.getProcedureNameList());
            this.comboProcedures.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            query.open(Sql.getTriggerNameList());
            this.comboTriggers.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    public String getDialogTitle() {
        return this.stringManager.getString("GrantProcedurePrivilegesWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("GrantProcedurePrivilegesWizard-tab-title");
    }

    public String getSqlCode() {
        String object = "";
        if (this.radioUser.isSelected()) {
            object = SQLUtil.createSqlName((String)this.comboUsers.getText());
        } else if (this.radioProcedure.isSelected()) {
            object = "PROCEDURE " + SQLUtil.createSqlName((String)this.comboProcedures.getText());
        } else if (this.radioTrigger.isSelected()) {
            object = "TRIGGER " + SQLUtil.createSqlName((String)this.comboTriggers.getText());
        } else if (this.radioView.isSelected()) {
            object = "VIEW " + SQLUtil.createSqlName((String)this.comboViews.getText());
        }
        return "GRANT EXECUTE ON PROCEDURE " + SQLUtil.createSqlName((String)this.comboObjects.getText()) + " TO " + object + (this.checkGrantOption.isSelected() ? " WITH GRANT OPTION" : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.groupObject = new ButtonGroup();
        this.jLabel5 = new JLabel();
        this.comboObjects = new ComboBox();
        this.radioUser = new JRadioButton();
        this.comboUsers = new ComboBox();
        this.radioProcedure = new JRadioButton();
        this.comboProcedures = new ComboBox();
        this.comboTriggers = new ComboBox();
        this.radioTrigger = new JRadioButton();
        this.comboViews = new ComboBox();
        this.radioView = new JRadioButton();
        this.checkGrantOption = new JCheckBox();
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("GrantProcedurePrivilegesWizard-privilege-for-object-dd"));
        this.groupObject.add(this.radioUser);
        this.radioUser.setSelected(true);
        this.radioUser.setText("Dla u\u017cytkownika");
        this.radioUser.setActionCommand(this.stringManager.getString("GrantProcedurePrivilegesWizard-for-user"));
        this.comboUsers.setEditable(true);
        this.groupObject.add(this.radioProcedure);
        this.radioProcedure.setText(this.stringManager.getString("GrantProcedurePrivilegesWizard-for-procedure"));
        this.groupObject.add(this.radioTrigger);
        this.radioTrigger.setText(this.stringManager.getString("GrantProcedurePrivilegesWizard-for-trigger"));
        this.groupObject.add(this.radioView);
        this.radioView.setText(this.stringManager.getString("GrantProcedurePrivilegesWizard-for-view"));
        this.checkGrantOption.setText(this.stringManager.getString("GrantProcedurePrivilegesWizard-grant-option"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.radioView, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboViews, -1, 251, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.radioUser, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboUsers, -1, 251, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.radioProcedure, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboProcedures, -1, 251, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.radioTrigger, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboTriggers, -1, 251, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 121, -2).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkGrantOption).addComponent((Component)this.comboObjects, -1, 247, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.comboObjects, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkGrantOption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioUser).addComponent((Component)this.comboUsers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioProcedure).addComponent((Component)this.comboProcedures, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioTrigger).addComponent((Component)this.comboTriggers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioView).addComponent((Component)this.comboViews, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

