/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class GrantTablePrivilegesWizard
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private Database database;
    private String objectName;
    private JCheckBox checkAll;
    private JCheckBox checkDelete;
    private JCheckBox checkGrantOption;
    private JCheckBox checkInsert;
    private JCheckBox checkReference;
    private JCheckBox checkSelect;
    private JCheckBox checkUpdate;
    private ComboBox comboObjects;
    private ComboBox comboProcedures;
    private ComboBox comboTriggers;
    private ComboBox comboUsers;
    private ComboBox comboViews;
    private ButtonGroup groupObject;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JRadioButton radioProcedure;
    private JRadioButton radioTrigger;
    private JRadioButton radioUser;
    private JRadioButton radioView;

    public GrantTablePrivilegesWizard(Database database, String objectName) {
        this.database = database;
        this.objectName = objectName;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardShow() {
        Query query = this.database.createQuery();
        try {
            query.open(Sql.getTabledNameList());
            this.comboObjects.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            this.comboObjects.setSelectedItem((Object)this.objectName);
            query.open(Sql.getUserNameList());
            this.comboUsers.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            query.open(Sql.getViewNameList());
            this.comboViews.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            query.open(Sql.getProcedureNameList());
            this.comboProcedures.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            query.open(Sql.getTriggerNameList());
            this.comboTriggers.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    public String getDialogTitle() {
        return this.stringManager.getString("GrantTablePrivilegesWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("GrantTablePrivilegesWizard-tab-title");
    }

    public String getSqlCode() {
        String privs = "";
        if (!this.checkAll.isSelected()) {
            if (this.checkSelect.isSelected()) {
                privs = privs + "SELECT";
            }
            if (this.checkInsert.isSelected()) {
                if (privs.length() > 0) {
                    privs = privs + ", ";
                }
                privs = privs + "INSERT";
            }
            if (this.checkUpdate.isSelected()) {
                if (privs.length() > 0) {
                    privs = privs + ", ";
                }
                privs = privs + "UPDATE";
            }
            if (this.checkDelete.isSelected()) {
                if (privs.length() > 0) {
                    privs = privs + ", ";
                }
                privs = privs + "DELETE";
            }
            if (this.checkReference.isSelected()) {
                if (privs.length() > 0) {
                    privs = privs + ", ";
                }
                privs = privs + "REFERENCES";
            }
        } else {
            privs = "ALL PRIVILEGES";
        }
        String object = "";
        if (this.radioUser.isSelected()) {
            object = SQLUtil.createSqlName((String)this.comboUsers.getText());
        } else if (this.radioProcedure.isSelected()) {
            object = "PROCEDURE " + SQLUtil.createSqlName((String)this.comboProcedures.getText());
        } else if (this.radioTrigger.isSelected()) {
            object = "TRIGGER " + SQLUtil.createSqlName((String)this.comboTriggers.getText());
        } else if (this.radioView.isSelected()) {
            object = "VIEW " + SQLUtil.createSqlName((String)this.comboViews.getText());
        }
        return "GRANT " + privs + " ON " + SQLUtil.createSqlName((String)this.comboObjects.getText()) + " TO " + object + (this.checkGrantOption.isSelected() ? " WITH GRANT OPTION" : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.groupObject = new ButtonGroup();
        this.jLabel5 = new JLabel();
        this.comboObjects = new ComboBox();
        this.jPanel1 = new JPanel();
        this.checkAll = new JCheckBox();
        this.checkSelect = new JCheckBox();
        this.checkInsert = new JCheckBox();
        this.checkUpdate = new JCheckBox();
        this.checkDelete = new JCheckBox();
        this.checkReference = new JCheckBox();
        this.radioUser = new JRadioButton();
        this.comboUsers = new ComboBox();
        this.radioProcedure = new JRadioButton();
        this.comboProcedures = new ComboBox();
        this.comboTriggers = new ComboBox();
        this.radioTrigger = new JRadioButton();
        this.comboViews = new ComboBox();
        this.radioView = new JRadioButton();
        this.checkGrantOption = new JCheckBox();
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("GrantTablePrivilegesWizard-privilege-for-object-dd"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Prawa"));
        this.checkAll.setText(this.stringManager.getString("GrantTablePrivilegesWizard-all"));
        this.checkAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GrantTablePrivilegesWizard.this.checkAllActionPerformed(evt);
            }
        });
        this.checkSelect.setText("SELECT");
        this.checkInsert.setText("INSERT");
        this.checkUpdate.setText("UPDATE");
        this.checkDelete.setText("DELETE");
        this.checkReference.setText("REFERENCE");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkAll).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.checkSelect, -1, 62, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkInsert, -1, 63, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkUpdate, -1, 66, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDelete, -1, 66, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkReference, -1, 84, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.checkAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkSelect).addComponent(this.checkInsert).addComponent(this.checkUpdate).addComponent(this.checkDelete).addComponent(this.checkReference)).addContainerGap(-1, Short.MAX_VALUE)));
        this.groupObject.add(this.radioUser);
        this.radioUser.setSelected(true);
        this.radioUser.setText(this.stringManager.getString("GrantTablePrivilegesWizard-for-user"));
        this.comboUsers.setEditable(true);
        this.groupObject.add(this.radioProcedure);
        this.radioProcedure.setText(this.stringManager.getString("GrantTablePrivilegesWizard-for-procedure"));
        this.groupObject.add(this.radioTrigger);
        this.radioTrigger.setText(this.stringManager.getString("GrantTablePrivilegesWizard-for-trigger"));
        this.groupObject.add(this.radioView);
        this.radioView.setText(this.stringManager.getString("GrantTablePrivilegesWizard-for-view"));
        this.checkGrantOption.setText(this.stringManager.getString("GrantTablePrivilegesWizard-grant-option"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(141, 141, 141).addComponent(this.checkGrantOption)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, 127, -2).addComponent(this.radioUser, -2, 123, -2).addComponent(this.radioProcedure, -2, 123, -2).addComponent(this.radioTrigger, -2, 123, -2).addComponent(this.radioView, -2, 123, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.comboObjects, -1, 234, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.comboViews, GroupLayout.Alignment.LEADING, -1, 234, Short.MAX_VALUE).addComponent((Component)this.comboTriggers, GroupLayout.Alignment.LEADING, -1, 234, Short.MAX_VALUE).addComponent((Component)this.comboProcedures, GroupLayout.Alignment.LEADING, -1, 234, Short.MAX_VALUE).addComponent((Component)this.comboUsers, -1, 234, Short.MAX_VALUE)).addGap(0, 0, 0)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent((Component)this.comboObjects, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkGrantOption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioUser).addComponent((Component)this.comboUsers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioProcedure).addComponent((Component)this.comboProcedures, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioTrigger).addComponent((Component)this.comboTriggers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioView).addComponent((Component)this.comboViews, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void checkAllActionPerformed(ActionEvent evt) {
        this.checkSelect.setEnabled(!this.checkAll.isSelected());
        this.checkInsert.setEnabled(!this.checkAll.isSelected());
        this.checkUpdate.setEnabled(!this.checkAll.isSelected());
        this.checkDelete.setEnabled(!this.checkAll.isSelected());
        this.checkReference.setEnabled(!this.checkAll.isSelected());
    }
}

