/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import pl.mpak.orbada.firebird.Consts;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ProcedureParameterDefinitionWizard
extends SqlCodeWizardPanel {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);
    private Database database;
    private int paramCount = 0;
    private boolean oneParam;
    private JButton buttonAddRow;
    private JButton buttonMoveDown;
    private JButton buttonMoveUp;
    private JButton buttonRemoveRow;
    private Action cmAddRow;
    private Action cmMoveDown;
    private Action cmMoveUp;
    private Action cmRemoveRow;
    private JComboBox comboDataTypes;
    private JComboBox comboDefaultValue;
    private JScrollPane jScrollPane1;
    private Table tableParameters;

    public ProcedureParameterDefinitionWizard(Database database, boolean oneParam) {
        this.database = database;
        this.oneParam = oneParam;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableParameters.setRowHeight(20);
        Object[][] row = null;
        if (this.oneParam) {
            row = new Object[][]{{"PARAMETR_1", "INTEGER", null}};
            ++this.paramCount;
        }
        this.tableParameters.setModel((TableModel)new DefaultTableModel(row, new String[]{this.stringManager.getString("ProcedureParameterDefinitionWizard-parameter-name"), this.stringManager.getString("ProcedureParameterDefinitionWizard-type"), this.stringManager.getString("default-value")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.comboDataTypes.setModel(new DefaultComboBoxModel<String>(Consts.COMBO_TYPS));
        this.tableParameters.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboDataTypes));
        this.tableParameters.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.comboDefaultValue));
        this.tableParameters.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tableParameters.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.tableParameters.getColumnModel().getColumn(2).setPreferredWidth(150);
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("ProcedureParameterDefinitionWizard-dialog-title");
    }

    public String getTabTitle() {
        return "";
    }

    public String getSqlCode() {
        StringBuffer columns = new StringBuffer();
        for (int i = 0; i < this.tableParameters.getRowCount(); ++i) {
            Object name = this.tableParameters.getValueAt(i, 0);
            Object dataType = this.tableParameters.getValueAt(i, 1);
            Object defaultValue = this.tableParameters.getValueAt(i, 2);
            if (name == null || dataType == null) continue;
            if (columns.length() > 0) {
                columns.append(",\n");
            }
            columns.append("  " + name);
            columns.append(" " + dataType);
            if (defaultValue == null || StringUtil.isEmpty((String)defaultValue.toString())) continue;
            columns.append(" = " + defaultValue.toString());
        }
        if (columns.length() > 0) {
            return "(\n" + columns.toString() + "\n)";
        }
        return "";
    }

    public boolean execute() {
        return false;
    }

    private void cancelEdit() {
        this.tableParameters.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
        this.tableParameters.getColumnModel().getColumn(2).getCellEditor().cancelCellEditing();
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.cmMoveDown = new Action();
        this.cmMoveUp = new Action();
        this.comboDataTypes = new JComboBox();
        this.comboDefaultValue = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tableParameters = new Table();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.buttonMoveUp = new JButton();
        this.buttonMoveDown = new JButton();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/add8.gif"));
        this.cmAddRow.setText(this.stringManager.getString("ProcedureParameterDefinitionWizard-cmAddRow-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureParameterDefinitionWizard.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/remove8.gif"));
        this.cmRemoveRow.setText(this.stringManager.getString("ProcedureParameterDefinitionWizard-cmRemoveRow-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureParameterDefinitionWizard.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.cmMoveDown.setActionCommandKey("cmMoveDown");
        this.cmMoveDown.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/down10.gif"));
        this.cmMoveDown.setText(this.stringManager.getString("ProcedureParameterDefinitionWizard-cmMoveDown-text"));
        this.cmMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureParameterDefinitionWizard.this.cmMoveDownActionPerformed(evt);
            }
        });
        this.cmMoveUp.setActionCommandKey("cmMoveUp");
        this.cmMoveUp.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/up10.gif"));
        this.cmMoveUp.setText(this.stringManager.getString("ProcedureParameterDefinitionWizard-cmMoveUp-text"));
        this.cmMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProcedureParameterDefinitionWizard.this.cmMoveUpActionPerformed(evt);
            }
        });
        this.comboDataTypes.setEditable(true);
        this.comboDefaultValue.setEditable(true);
        this.comboDefaultValue.setModel(new DefaultComboBoxModel<String>(new String[]{"", "NULL", "USER"}));
        this.setPreferredSize(new Dimension(600, 300));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.tableParameters.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.tableParameters);
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveUp.setAction((javax.swing.Action)this.cmMoveUp);
        this.buttonMoveUp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveDown.setAction((javax.swing.Action)this.cmMoveDown);
        this.buttonMoveDown.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 499, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonMoveUp, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonRemoveRow, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonAddRow, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonMoveDown, -1, 75, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveDown))).addContainerGap()));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getRowCount() > 0 && this.tableParameters.getSelectedRow() >= 0) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableParameters.getModel()).removeRow(this.tableParameters.getSelectedRow());
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getRowCount() == 0 || this.tableParameters.getValueAt(this.tableParameters.getRowCount() - 1, 0) != null) {
            ++this.paramCount;
            ((DefaultTableModel)this.tableParameters.getModel()).addRow(new Object[]{"PARAMETR_" + this.paramCount, "INTEGER", null});
            this.tableParameters.changeSelection(this.tableParameters.getRowCount() - 1, this.tableParameters.getRowCount() - 1);
        }
    }

    private void cmMoveDownActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getSelectedRow() >= 0 && this.tableParameters.getSelectedRow() < this.tableParameters.getRowCount() - 1) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableParameters.getModel()).moveRow(this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow() + 1);
            this.tableParameters.changeSelection(this.tableParameters.getSelectedRow() + 1, this.tableParameters.getSelectedRow() + 1);
        }
    }

    private void cmMoveUpActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getSelectedRow() > 0) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableParameters.getModel()).moveRow(this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow() - 1);
            this.tableParameters.changeSelection(this.tableParameters.getSelectedRow() - 1, this.tableParameters.getSelectedRow() - 1);
        }
    }
}

