/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.services;

import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FirebirdDatabaseProvider
extends DatabaseProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Firebird".equals(database.getDriverType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnection(Database database) {
        Query query = database.createQuery();
        try {
            query.open("SELECT 0 FROM RDB$RELATION_FIELDS WHERE RDB$RELATION_NAME = 'RDB$GENERATORS' AND RDB$FIELD_NAME = 'RDB$DESCRIPTION'");
            if (query.eof()) {
                database.getUserProperties().setProperty("generator-description", "false");
            } else {
                database.getUserProperties().setProperty("generator-description", "true");
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    public void beforeDisconnect(Database database) {
    }

    public String getDescription() {
        return this.stringManager.getString("FirebirdDatabaseProvider-description");
    }

    public String getGroupName() {
        return "Firebird";
    }
}

