/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.services;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.cm.CreateDomainAction;
import pl.mpak.orbada.firebird.cm.CreateExceptionAction;
import pl.mpak.orbada.firebird.cm.CreateProcedureAction;
import pl.mpak.orbada.firebird.cm.CreateSequenceAction;
import pl.mpak.orbada.firebird.cm.CreateTriggerAction;
import pl.mpak.orbada.firebird.gui.freezing.FreezeFactory;
import pl.mpak.orbada.firebird.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.IDatabaseObject;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class FirebirdPerspectiveProvider
extends PerspectiveProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Firebird".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("FirebirdPerspectiveProvider-description");
    }

    public String getGroupName() {
        return "Firebird";
    }

    public void initialize() {
        final JMenu wizards = new JMenu(this.stringManager.getString("FirebirdPerspectiveProvider-wizzards"));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                wizards.add((Action)((Object)new CreateProcedureAction(FirebirdPerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateTriggerAction(FirebirdPerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.addSeparator();
                wizards.add((Action)((Object)new CreateSequenceAction(FirebirdPerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateDomainAction(FirebirdPerspectiveProvider.this.accesibilities.getDatabase())));
                wizards.add((Action)((Object)new CreateExceptionAction(FirebirdPerspectiveProvider.this.accesibilities.getDatabase())));
            }
        });
        this.accesibilities.addMenu(wizards);
        JToolBar toolBar = new JToolBar("Firebird");
        toolBar.add((Component)new ToolButton((Action)((Object)OrbadaFirebirdPlugin.findObjectAction)));
        toolBar.addSeparator();
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateProcedureAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateTriggerAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateSequenceAction(this.accesibilities.getDatabase()))));
        toolBar.add((Component)new ToolButton((Action)((Object)new CreateDomainAction(this.accesibilities.getDatabase()))));
        this.accesibilities.addToolBar(toolBar);
    }

    public void processMessage(PluginMessage message) {
        if (this.getAccesibilities() != null && this.getAccesibilities().getDatabase() != null && this.getAccesibilities().getDatabase().getUniqueID().equals(message.getDestinationId()) && message.isMessageId("freeze-object")) {
            final IDatabaseObject object = (IDatabaseObject)message.getObject();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FreezeViewService service = new FreezeFactory().createInstance(object.getObjectType(), StringUtil.nvl((String)object.getSchemaName(), (String)object.getCatalogName()), object.getObjectName());
                    IPerspectiveAccesibilities accessibilities = FirebirdPerspectiveProvider.this.application.getActivePerspective();
                    if (service != null && accessibilities != null) {
                        accessibilities.createView((ViewProvider)service);
                    }
                }
            });
            message.setServed(true);
        }
    }
}

