/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.services;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.firebird.OrbadaFirebirdPlugin;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.firebird.gui.functions.FunctionArgumentsPanel;
import pl.mpak.orbada.firebird.gui.procedures.ProcedureArgumentsPanel;
import pl.mpak.orbada.firebird.gui.tables.TableColumnsPanel;
import pl.mpak.orbada.firebird.gui.views.ViewColumnsPanel;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalColumnProvider
extends UniversalActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaFirebirdPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        this.setText(this.stringManager.getString("columns"));
        this.setShortCut(117, 2);
        this.setTooltip(this.stringManager.getString("UniversalColumnProvider-hint"));
        this.setActionCommandKey("UniversalColumnProvider");
        this.addActionListener(this.createActionListener());
        return "Firebird".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return false;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return "Universal Firebird Column or Param List Provider";
    }

    private boolean resolveObject(String type, String object) {
        if ("TABLE".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("columns"));
            TableColumnsPanel panel = new TableColumnsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, null, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("VIEW".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("columns"));
            ViewColumnsPanel panel = new ViewColumnsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, null, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("PROCEDURE".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("parameters"));
            ProcedureArgumentsPanel panel = new ProcedureArgumentsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, null, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + object + "\"", (JComponent)panel);
            return true;
        }
        if ("FUNCTION".equalsIgnoreCase(type)) {
            this.setText(this.stringManager.getString("parameters"));
            FunctionArgumentsPanel panel = new FunctionArgumentsPanel(this.accessibilities.getViewAccesibilities());
            panel.refresh(null, null, object);
            this.accessibilities.addResultTab(this.getText() + " \"" + object + "\"", (JComponent)panel);
            return true;
        }
        return false;
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                block9: {
                    try {
                        String[] words = UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getWordsAt(UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getCaretPosition());
                        String object = null;
                        if (words == null || words.length <= 0) break block9;
                        if (words.length >= 1) {
                            object = SQLUtil.normalizeSqlName((String)words[0]);
                        }
                        boolean found = false;
                        Query query = UniversalColumnProvider.this.accessibilities.getViewAccesibilities().getDatabase().createQuery();
                        try {
                            query.setSqlText(Sql.getObjectTypes());
                            query.paramByName("object_name").setString(object);
                            query.open();
                            if (!query.eof()) {
                                found = UniversalColumnProvider.this.resolveObject(query.fieldByName("object_type").getString(), object);
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public String getGroupName() {
        return "Firebird";
    }
}

