/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.syntax.parser;

import java.util.ArrayList;
import pl.mpak.sky.gui.swing.syntax.structure.BlockElement;
import pl.mpak.sky.gui.swing.syntax.structure.CallableElement;
import pl.mpak.sky.gui.swing.syntax.structure.CallableParameter;
import pl.mpak.sky.gui.swing.syntax.structure.CodeElement;
import pl.mpak.sky.gui.swing.syntax.structure.Condition;
import pl.mpak.sky.gui.swing.syntax.structure.Cursor;
import pl.mpak.sky.gui.swing.syntax.structure.DeclaredElement;
import pl.mpak.sky.gui.swing.syntax.structure.Else;
import pl.mpak.sky.gui.swing.syntax.structure.Expression;
import pl.mpak.sky.gui.swing.syntax.structure.For;
import pl.mpak.sky.gui.swing.syntax.structure.GotoLabel;
import pl.mpak.sky.gui.swing.syntax.structure.If;
import pl.mpak.sky.gui.swing.syntax.structure.ParserException;
import pl.mpak.sky.gui.swing.syntax.structure.Procedure;
import pl.mpak.sky.gui.swing.syntax.structure.SqlStructureParser;
import pl.mpak.sky.gui.swing.syntax.structure.Statement;
import pl.mpak.sky.gui.swing.syntax.structure.Trigger;
import pl.mpak.sky.gui.swing.syntax.structure.Variable;
import pl.mpak.sky.gui.swing.syntax.structure.While;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirebirdPSqlStructureParser
extends SqlStructureParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockElement parse() throws ParserException {
        Procedure block = null;
        try {
            while (this.nextToken(true) != null) {
                if (this.isToken("procedure")) {
                    block = new Procedure(null);
                    this.parseCallable((CallableElement)block);
                } else {
                    if (!this.isToken("trigger")) continue;
                    block = new Trigger(null);
                    this.parseTrigger((Trigger)block);
                }
                break;
            }
        }
        catch (ParserException parserException) {
        }
        finally {
            this.updateKeyWordStyles();
        }
        return block;
    }

    private String parseIdentifier() throws ParserException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 9);
        this.nextToken(true);
        while (this.isToken(".")) {
            sb.append(this.getTokenString());
            this.nextToken(true);
            sb.append(this.getTokenString());
            this.putKeyWord(this.getTokenString(), 9);
            this.nextToken(true);
        }
        return sb.toString();
    }

    private DeclaredElement parseParameter(CodeElement callable) throws ParserException {
        this.skipBlank();
        CallableParameter param = new CallableParameter(callable);
        param.setStartOffset(this.getStartOffset());
        param.setName(this.getTokenString());
        this.putKeyWord(this.getTokenString(), 21);
        this.nextToken(true);
        param.setType(this.parseDeclareType());
        param.setEndOffset(this.getEndOffset());
        return param;
    }

    private void parseParameters(CodeElement block, ArrayList<DeclaredElement> parameterList) throws ParserException {
        this.nextToken(true);
        if (!this.isToken(")")) {
            parameterList.add(this.parseParameter(block));
            while (this.isToken(",")) {
                this.nextToken(true);
                parameterList.add(this.parseParameter(block));
            }
            this.nextToken(true);
        }
    }

    private BlockElement parseCallable(CallableElement block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        block.setName(this.parseIdentifier());
        this.skipBlank();
        if (this.isToken("(")) {
            this.parseParameters((CodeElement)block, block.getParameterList());
        }
        if (this.isToken("returns")) {
            this.nextToken(true);
            if (this.isToken("(")) {
                this.parseParameters((CodeElement)block, block.getParameterList());
            }
        }
        while (!this.isToken("as") && !this.isToken("is")) {
            this.nextToken(true);
        }
        this.nextToken(true);
        this.parseDeclares((BlockElement)block);
        block.setBeginBlockOffset(this.getStartOffset());
        this.parseBlock((BlockElement)block);
        if (this.isToken(block.getName())) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private BlockElement parseTrigger(Trigger trigger) throws ParserException {
        trigger.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        trigger.setName(this.parseIdentifier());
        this.nextToken(true);
        while (!this.isToken("as") && !this.isToken("is")) {
            this.nextToken(true);
        }
        this.nextToken(true);
        this.parseDeclares((BlockElement)trigger);
        trigger.setBeginBlockOffset(this.getStartOffset());
        this.parseBlock((BlockElement)trigger);
        if (this.isToken(trigger.getName())) {
            this.nextToken(true);
        }
        trigger.setEndOffset(this.getEndOffset());
        return trigger;
    }

    private String parseDeclareType() throws ParserException {
        StringBuffer sb = new StringBuffer();
        while (!(this.isToken(")") || this.isToken(",") || this.isToken(";"))) {
            if (this.isToken("(")) {
                sb.append(this.getTokenString());
                this.nextToken(false);
                while (!this.isToken(")")) {
                    sb.append(this.getTokenString());
                    this.nextToken(false);
                }
                sb.append(this.getTokenString());
            } else if (this.getToken().styleId != 2 && this.getToken().styleId != 16) {
                sb.append(this.getTokenString());
            } else {
                sb.append("");
            }
            this.nextToken(false);
        }
        return sb.toString().trim();
    }

    private DeclaredElement parseDeclaration(int startOffset, String name, BlockElement block) throws ParserException {
        this.skipBlank();
        Variable declare = new Variable((CodeElement)block);
        declare.setName(name);
        declare.setStartOffset(startOffset);
        declare.setType(this.parseDeclareType());
        declare.setEndOffset(this.getEndOffset());
        return declare;
    }

    private Cursor parseCursor(int startOffset, String name, Cursor block) throws ParserException {
        this.skipBlank();
        if (this.isToken("for")) {
            this.nextToken(true);
        }
        block.setName(name);
        block.setStartOffset(startOffset);
        while (!this.isToken(";")) {
            this.nextToken(true);
        }
        block.setEndOffset(this.getEndOffset());
        return block;
    }

    private void declareElement(BlockElement block) throws ParserException {
        this.skipBlank();
        int startOffset = this.getStartOffset();
        if (this.isToken("declare")) {
            this.nextToken(true);
        }
        if (this.isToken("variable")) {
            this.nextToken(true);
        }
        String name = this.getTokenString();
        this.putKeyWord(name, 21);
        this.nextToken(true);
        if (this.isToken("cursor")) {
            block.putCallable((CallableElement)this.parseCursor(startOffset, name, new Cursor((CodeElement)block)));
        } else {
            block.putDeclare(this.parseDeclaration(startOffset, name, block));
        }
        if (this.isToken(";")) {
            this.nextToken(true);
        }
    }

    private void parseDeclares(BlockElement block) throws ParserException {
        if (!this.isToken("begin")) {
            this.declareElement(block);
            while (!this.isToken("begin")) {
                this.declareElement(block);
            }
        }
    }

    private void parseStatement(BlockElement block) throws ParserException {
        this.skipBlank();
        if (this.isToken("if")) {
            block.putCode((CodeElement)this.parseIf(new If((CodeElement)block)));
        } else if (this.isToken("for")) {
            block.putCode((CodeElement)this.parseFor(new For((CodeElement)block)));
        } else if (this.isToken("while")) {
            block.putCode((CodeElement)this.parseWhile(new While((CodeElement)block)));
        } else {
            int startOffset = this.getStartOffset();
            String labelName = this.getTokenString();
            this.nextToken(true);
            if (this.isToken(":")) {
                GotoLabel label = new GotoLabel((CodeElement)block);
                label.setName(labelName);
                this.putKeyWord(labelName, 21);
                label.setStartOffset(startOffset);
                label.setEndOffset(this.getEndOffset());
                block.putCode((CodeElement)label);
            } else {
                Statement statement = new Statement((CodeElement)block);
                statement.setStartOffset(startOffset);
                while (!this.isToken(";")) {
                    this.nextToken(true);
                }
                statement.setEndOffset(this.getEndOffset());
                block.putCode((CodeElement)statement);
            }
            this.nextToken(false);
        }
    }

    private If parseIf(If block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Condition cond = null;
        while (!this.isToken("then")) {
            if (cond == null) {
                cond = new Condition((CodeElement)block);
                cond.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (cond != null) {
            block.setCondition(cond);
            cond.setEndOffset(this.getEndOffset());
        }
        this.nextToken(true);
        if (this.isToken("begin")) {
            BlockElement bt = this.parseBlock(new BlockElement((CodeElement)block, "Block"));
            block.putCode((CodeElement)bt);
            block.setEndOffset(bt.getEndOffset());
        } else {
            this.parseStatement((BlockElement)block);
            if (block.getCodeList().size() > 0) {
                block.setEndOffset(((CodeElement)block.getCodeList().get(block.getCodeList().size() - 1)).getEndOffset());
            } else {
                block.setEndOffset(this.getEndOffset());
            }
        }
        this.skipBlank();
        if (this.isToken("else")) {
            Else eb = new Else((CodeElement)block);
            eb.setStartOffset(this.getStartOffset());
            this.nextToken(true);
            if (this.isToken("begin")) {
                BlockElement bt = this.parseBlock(new BlockElement((CodeElement)eb, "Block"));
                eb.putCode((CodeElement)bt);
                eb.setEndOffset(bt.getEndOffset());
            } else {
                this.parseStatement((BlockElement)eb);
                if (block.getCodeList().size() > 0) {
                    eb.setEndOffset(((CodeElement)eb.getCodeList().get(eb.getCodeList().size() - 1)).getEndOffset());
                } else {
                    eb.setEndOffset(this.getEndOffset());
                }
            }
            block.setElseBlock(eb);
            block.setEndOffset(eb.getEndOffset());
            this.skipBlank();
        }
        return block;
    }

    private For parseFor(For block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Expression expr = null;
        while (!this.isToken("do")) {
            if (expr == null) {
                expr = new Expression((CodeElement)block);
                expr.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (expr != null) {
            block.setExpression(expr);
            expr.setEndOffset(this.getEndOffset());
        }
        this.nextToken(true);
        if (this.isToken("begin")) {
            BlockElement bt = this.parseBlock(new BlockElement((CodeElement)block, "Block"));
            block.putCode((CodeElement)bt);
            block.setEndOffset(bt.getEndOffset());
        } else {
            this.parseStatement((BlockElement)block);
            if (block.getCodeList().size() > 0) {
                block.setEndOffset(((CodeElement)block.getCodeList().get(block.getCodeList().size() - 1)).getEndOffset());
            } else {
                block.setEndOffset(this.getEndOffset());
            }
        }
        this.skipBlank();
        return block;
    }

    private While parseWhile(While block) throws ParserException {
        block.setStartOffset(this.getStartOffset());
        this.nextToken(true);
        Expression expr = null;
        while (!this.isToken("do")) {
            if (expr == null) {
                expr = new Expression((CodeElement)block);
                expr.setStartOffset(this.getStartOffset());
            }
            this.nextToken(true);
        }
        if (expr != null) {
            block.setExpression(expr);
            expr.setEndOffset(this.getEndOffset());
        }
        this.nextToken(true);
        if (this.isToken("begin")) {
            BlockElement bt = this.parseBlock(new BlockElement((CodeElement)block, "Block"));
            block.putCode((CodeElement)bt);
            block.setEndOffset(bt.getEndOffset());
        } else {
            this.parseStatement((BlockElement)block);
            if (block.getCodeList().size() > 0) {
                block.setEndOffset(((CodeElement)block.getCodeList().get(block.getCodeList().size() - 1)).getEndOffset());
            } else {
                block.setEndOffset(this.getEndOffset());
            }
        }
        this.skipBlank();
        return block;
    }

    private BlockElement parseBlockStatements(BlockElement block) throws ParserException {
        this.skipBlank();
        while (!this.isToken("end")) {
            if (this.isToken("if")) {
                block.putCode((CodeElement)this.parseIf(new If((CodeElement)block)));
                continue;
            }
            if (this.isToken("for")) {
                block.putCode((CodeElement)this.parseFor(new For((CodeElement)block)));
                continue;
            }
            if (this.isToken("while")) {
                block.putCode((CodeElement)this.parseWhile(new While((CodeElement)block)));
                continue;
            }
            if (this.isToken("begin")) {
                block.putCode((CodeElement)this.parseBlock(new BlockElement((CodeElement)block, "Block")));
                continue;
            }
            this.parseStatement(block);
            this.skipBlank();
        }
        this.nextToken(false);
        block.setEndOffset(this.getEndOffset());
        this.skipBlank();
        return block;
    }

    private BlockElement parseBlock(BlockElement block) throws ParserException {
        this.skipBlank();
        if (block.getStartOffset() == 0) {
            block.setStartOffset(this.getStartOffset());
        }
        this.nextToken(true);
        if (!this.isToken("end")) {
            this.parseBlockStatements(block);
        }
        if (block.getEndOffset() == 0) {
            block.setEndOffset(this.getEndOffset());
        }
        return block;
    }
}

