/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.firebird.util;

import java.awt.EventQueue;
import pl.mpak.orbada.firebird.Sql;
import pl.mpak.orbada.gui.comps.OrbadaJavaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class SourceCreator {
    public static final int FBFT_SMALLINT = 7;
    public static final int FBFT_INTEGER = 8;
    public static final int FBFT_QUAD = 9;
    public static final int FBFT_FLOAT = 10;
    public static final int FBFT_D_FLOAT = 11;
    public static final int FBFT_SQL_DATE = 12;
    public static final int FBFT_SQL_TIME = 13;
    public static final int FBFT_FCHAR = 14;
    public static final int FBFT_FCHAR2 = 15;
    public static final int FBFT_INT64 = 16;
    public static final int FBFT_DOUBLE_PRECISION = 27;
    public static final int FBFT_TIMESTAMP = 35;
    public static final int FBFT_VARCHAR = 37;
    public static final int FBFT_VARCHAR2 = 38;
    public static final int FBFT_CSTRING = 40;
    public static final int FBFT_CSTRING2 = 41;
    public static final int FBFT_BLOB_ID = 45;
    public static final int FBFT_BLOB = 261;
    public static final int TRIGGER_BEFORE = 0;
    public static final int TRIGGER_AFTER = 1;
    public static final int TRIGGER_INSERT = 1;
    public static final int TRIGGER_UPDATE = 2;
    public static final int TRIGGER_DELETE = 3;
    public static final int TRIGGER_CONNECT = 8192;
    public static final int TRIGGER_DISCONNECT = 8193;
    public static final int TRIGGER_TRANSACTION_START = 8194;
    public static final int TRIGGER_TRANSACTION_COMMIT = 8195;
    public static final int TRIGGER_TRANSACTION_ROLLBACK = 8196;
    private Database database;
    private SyntaxTextArea textArea;

    public SourceCreator(Database database) {
        this.database = database;
    }

    public SourceCreator(Database database, SyntaxTextArea textArea) {
        this(database);
        this.textArea = textArea;
    }

    public String getSource(final String schemaName, final String objectType, final String objectName) {
        final String source = StringUtil.equals((String)objectType, (String)"TRIGGER") ? this.createTrigger(objectName).replace('\r', '\n') : (StringUtil.equals((String)objectType, (String)"VIEW") ? this.createView(objectName) : (StringUtil.equals((String)objectType, (String)"PROCEDURE") ? this.createProcedure(objectName).replace('\r', '\n') : (StringUtil.equals((String)objectType, (String)"FUNCTION") ? this.createFunction(objectName) : (StringUtil.equals((String)objectType, (String)"TABLE") ? this.createTable(objectName) : ""))));
        if (this.textArea != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (SourceCreator.this.textArea instanceof OrbadaSyntaxTextArea) {
                        ((OrbadaSyntaxTextArea)SourceCreator.this.textArea).setDatabaseObject(schemaName, objectType, objectName, source);
                    } else if (SourceCreator.this.textArea instanceof OrbadaJavaSyntaxTextArea) {
                        ((OrbadaJavaSyntaxTextArea)SourceCreator.this.textArea).setDatabaseObject(schemaName, objectType, objectName, source);
                    }
                    SourceCreator.this.textArea.getEditorArea().setCaretPosition(0);
                }
            });
        }
        return source;
    }

    private static String decodeCommandType(int trgType) {
        switch (trgType) {
            case 1: {
                return "INSERT";
            }
            case 2: {
                return "UPDATE";
            }
            case 3: {
                return "DELETE";
            }
            case 8192: {
                return "CONNECT";
            }
            case 8193: {
                return "DISCONNECT";
            }
            case 8194: {
                return "TRANSACTION START";
            }
            case 8195: {
                return "TRANSACTION COMMIT";
            }
            case 8196: {
                return "TRANSACTION ROLLBACK";
            }
        }
        return null;
    }

    public static String decodeTriggerType(String trgType, int trgTypeValue) {
        String tmp;
        if (!StringUtil.isEmpty((String)trgType)) {
            return trgType;
        }
        StringBuilder result = new StringBuilder();
        if (trgTypeValue >= 8192 && trgTypeValue <= 8196 && (tmp = SourceCreator.decodeCommandType(trgTypeValue)) != null) {
            result.append(tmp);
        } else {
            if ((tmp = SourceCreator.decodeCommandType((++trgTypeValue & 0x60) >> 5)) != null) {
                result.append(tmp);
            }
            if ((tmp = SourceCreator.decodeCommandType((trgTypeValue & 0x18) >> 3)) != null) {
                if (result.length() > 0) {
                    result.append(" OR ");
                }
                result.append(tmp);
            }
            if ((tmp = SourceCreator.decodeCommandType((trgTypeValue & 6) >> 1)) != null) {
                if (result.length() > 0) {
                    result.append(" OR ");
                }
                result.append(tmp);
            }
            switch (trgTypeValue & 1) {
                case 0: {
                    result.insert(0, "BEFORE ");
                    break;
                }
                case 1: {
                    result.insert(0, "AFTER ");
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTrigger(String objectName) {
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getTriggerSource());
            source.paramByName("TRIGGER_NAME").setString(objectName);
            source.open();
            StringBuilder sb = new StringBuilder();
            if (!source.eof()) {
                sb.append("CREATE OR ALTER TRIGGER " + SQLUtil.createSqlName((String)objectName, (Database)this.database) + (source.fieldByName("RDB$TRIGGER_TYPE").getInteger() >= 8192 && source.fieldByName("RDB$TRIGGER_TYPE").getInteger() <= 8196 ? " ON " : " FOR ") + SQLUtil.createSqlName((String)source.fieldByName("TABLE_NAME").getString(), (Database)this.database) + "\n");
                if (!StringUtil.toBoolean((String)source.fieldByName("TRIGGER_ACTIVE").getString())) {
                    sb.append("  INACTIVE\n");
                }
                sb.append("  " + SourceCreator.decodeTriggerType(null, source.fieldByName("RDB$TRIGGER_TYPE").getInteger()) + " POSITION " + source.fieldByName("TRIGGER_SEQUENCE").getString() + "\n");
                sb.append(source.fieldByName("TRIGGER_SOURCE").getString());
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createView(String objectName) {
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getViewOnlyColumnList());
            source.paramByName("VIEW_NAME").setString(objectName);
            source.open();
            StringBuilder columns = new StringBuilder();
            while (!source.eof()) {
                if (columns.length() > 0) {
                    columns.append(", ");
                }
                columns.append("\"" + source.fieldByName("FIELD_NAME").getString() + "\"");
                source.next();
            }
            source.setSqlText(Sql.getViewSource());
            source.paramByName("VIEW_NAME").setString(objectName);
            source.open();
            StringBuilder sb = new StringBuilder();
            if (!source.eof()) {
                sb.append("DROP VIEW " + SQLUtil.createSqlName((String)objectName, (Database)this.database) + "\n/\n");
                sb.append("CREATE VIEW " + SQLUtil.createSqlName((String)objectName, (Database)this.database) + "\n");
                sb.append("  (" + columns.toString() + ") AS ");
                sb.append(source.fieldByName("VIEW_SOURCE").getString());
                sb.append("\n/\n");
            }
            source.setSqlText(Sql.getRelationDescription());
            source.paramByName("RELATION_NAME").setString(objectName);
            source.open();
            if (!source.eof()) {
                sb.append("UPDATE RDB$RELATIONS SET RDB$DESCRIPTION = '" + source.fieldByName("DESCRIPTION").getString() + "' WHERE RDB$RELATION_NAME = '" + objectName + "'\n/\n");
            }
            source.setSqlText(Sql.getRelationColumnDescriptionList());
            source.paramByName("RELATION_NAME").setString(objectName);
            source.open();
            while (!source.eof()) {
                sb.append("UPDATE RDB$RELATION_FIELDS SET RDB$DESCRIPTION = '" + source.fieldByName("DESCRIPTION").getString() + "' WHERE RDB$FIELD_NAME = '" + source.fieldByName("FIELD_NAME").getString() + "' AND RDB$RELATION_NAME = '" + objectName + "'\n/\n");
                source.next();
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTable(String objectName) {
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getColumnList(null));
            source.paramByName("TABLE_NAME").setString(objectName);
            source.open();
            StringBuilder columns = new StringBuilder();
            while (!source.eof()) {
                if (columns.length() > 0) {
                    columns.append(",");
                }
                columns.append("\n  " + SQLUtil.createSqlName((String)source.fieldByName("FIELD_NAME").getString(), (Database)this.database));
                if (source.fieldByName("DOMAIN_NAME").getString().startsWith("RDB$")) {
                    if (!source.fieldByName("COMPUTED_SOURCE").isNull()) {
                        columns.append(" COMPUTED " + source.fieldByName("COMPUTED_SOURCE").getString());
                    } else {
                        columns.append(" " + source.fieldByName("DISPLAY_TYPE").getString());
                        if (!source.fieldByName("DEFAULT_SOURCE").isNull()) {
                            columns.append(" " + source.fieldByName("DEFAULT_SOURCE").getString());
                        }
                        if ("N".equalsIgnoreCase(source.fieldByName("NULL_FLAG").getString())) {
                            columns.append(" NOT NULL");
                        }
                    }
                } else {
                    columns.append(" " + source.fieldByName("DOMAIN_NAME").getString());
                }
                source.next();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("CREATE TABLE " + SQLUtil.createSqlName((String)objectName, (Database)this.database) + " (");
            sb.append(columns.toString());
            sb.append("\n)\n/\n");
            source.setSqlText(Sql.getRelationDescription());
            source.paramByName("RELATION_NAME").setString(objectName);
            source.open();
            if (!source.eof()) {
                sb.append("UPDATE RDB$RELATIONS SET RDB$DESCRIPTION = '" + source.fieldByName("DESCRIPTION").getString() + "' WHERE RDB$RELATION_NAME = '" + objectName + "'\n/\n");
            }
            source.setSqlText(Sql.getRelationColumnDescriptionList());
            source.paramByName("RELATION_NAME").setString(objectName);
            source.open();
            while (!source.eof()) {
                sb.append("UPDATE RDB$RELATION_FIELDS SET RDB$DESCRIPTION = '" + source.fieldByName("DESCRIPTION").getString() + "' WHERE RDB$FIELD_NAME = '" + source.fieldByName("FIELD_NAME").getString() + "' AND RDB$RELATION_NAME = '" + objectName + "'\n/\n");
                source.next();
            }
            source.setSqlText(Sql.getIndexList(null));
            source.paramByName("TABLE_NAME").setString(objectName);
            source.open();
            while (!source.eof()) {
                if (!source.fieldByName("INDEX_NAME").getString().startsWith("RDB$")) {
                    sb.append("CREATE");
                    if ("Y".equalsIgnoreCase(source.fieldByName("UNIQUINES").getString())) {
                        sb.append(" UNIQUE");
                    }
                    if ("DESC".equalsIgnoreCase(source.fieldByName("ORDERING").getString())) {
                        sb.append(" DESC");
                    }
                    sb.append(" INDEX");
                    sb.append(" " + SQLUtil.createSqlName((String)source.fieldByName("INDEX_NAME").getString(), (Database)this.database));
                    sb.append(" ON " + SQLUtil.createSqlName((String)objectName, (Database)this.database));
                    if (!source.fieldByName("EXPRESSION_SOURCE").isNull()) {
                        sb.append(" COMPUTED BY " + source.fieldByName("EXPRESSION_SOURCE").getString());
                    } else {
                        sb.append(" (" + source.fieldByName("COLUMNS").getString() + ")");
                    }
                    sb.append("\n/\n");
                }
                source.next();
            }
            source.setSqlText(Sql.getConstraintList(null));
            source.paramByName("TABLE_NAME").setString(objectName);
            source.open();
            while (!source.eof()) {
                if (source.fieldByName("CONSTRAINT_TYPE").getString().equalsIgnoreCase("CHECK")) {
                    sb.append("ALTER TABLE " + SQLUtil.createSqlName((String)objectName, (Database)this.database) + " ADD CONSTRAINT " + SQLUtil.createSqlName((String)source.fieldByName("CONSTRAINT_NAME").getString(), (Database)this.database) + " " + source.fieldByName("CHECK_CLAUSE").getString());
                    sb.append("\n/\n");
                } else if (source.fieldByName("CONSTRAINT_TYPE").getString().equalsIgnoreCase("PRIMARY KEY")) {
                    sb.append("ALTER TABLE " + SQLUtil.createSqlName((String)objectName, (Database)this.database) + " ADD CONSTRAINT " + SQLUtil.createSqlName((String)source.fieldByName("CONSTRAINT_NAME").getString(), (Database)this.database) + " PRIMARY KEY (" + source.fieldByName("COLUMNS").getString() + ")");
                    sb.append("\n/\n");
                }
                source.next();
            }
            source.setSqlText(Sql.getTableReferencesWithList(null));
            source.paramByName("TABLE_NAME").setString(objectName);
            source.open();
            while (!source.eof()) {
                sb.append("ALTER TABLE " + SQLUtil.createSqlName((String)objectName, (Database)this.database) + " ADD CONSTRAINT " + SQLUtil.createSqlName((String)source.fieldByName("CONSTRAINT_NAME").getString(), (Database)this.database) + " FOREIGN KEY (" + source.fieldByName("COLUMNS").getString() + ")" + " REFERENCES " + SQLUtil.createSqlName((String)source.fieldByName("REF_TABLE_NAME").getString(), (Database)this.database) + " (" + source.fieldByName("REF_COLUMNS").getString() + ")");
                sb.append("\n/\n");
                source.next();
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createProcedure(String objectName) {
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getProcedureSimpleArgumentList());
            source.paramByName("PROCEDURE_NAME").setString(objectName);
            source.paramByName("PARAMETER_TYPE").setInteger(0);
            source.open();
            String lastComment = null;
            StringBuilder paramIn = new StringBuilder();
            while (!source.eof()) {
                if (paramIn.length() > 0) {
                    paramIn.append("," + (lastComment != null ? lastComment : "") + "\n");
                }
                lastComment = source.fieldByName("DESCRIPTION").isNull() ? null : " -- " + source.fieldByName("DESCRIPTION").getString();
                paramIn.append("  " + source.fieldByName("PARAMETER_NAME").getString() + " " + source.fieldByName("DISPLAY_TYPE").getString() + (source.fieldByName("DEFAULT_SOURCE").isNull() ? "" : " " + source.fieldByName("DEFAULT_SOURCE").getString()));
                source.next();
            }
            if (lastComment != null) {
                paramIn.append(lastComment);
            }
            source.close();
            source.paramByName("PROCEDURE_NAME").setString(objectName);
            source.paramByName("PARAMETER_TYPE").setInteger(1);
            source.open();
            StringBuilder paramOut = new StringBuilder();
            while (!source.eof()) {
                if (paramOut.length() > 0) {
                    paramOut.append("," + (lastComment != null ? lastComment : "") + "\n");
                }
                lastComment = source.fieldByName("DESCRIPTION").isNull() ? null : " -- " + source.fieldByName("DESCRIPTION").getString();
                paramOut.append("  " + source.fieldByName("PARAMETER_NAME").getString() + " " + source.fieldByName("DISPLAY_TYPE").getString() + (source.fieldByName("DEFAULT_SOURCE").isNull() ? "" : " " + source.fieldByName("DEFAULT_SOURCE").getString()));
                source.next();
            }
            if (lastComment != null) {
                paramOut.append(lastComment);
            }
            source.setSqlText(Sql.getProcedureSource());
            source.paramByName("PROCEDURE_NAME").setString(objectName);
            source.open();
            StringBuilder sb = new StringBuilder();
            if (!source.eof()) {
                sb.append("CREATE OR ALTER PROCEDURE " + SQLUtil.createSqlName((String)objectName, (Database)this.database));
                if (paramIn.length() > 0) {
                    sb.append(" (\n" + paramIn.toString() + "\n)");
                }
                if (paramOut.length() > 0) {
                    sb.append(" RETURNS (\n" + paramOut.toString() + "\n)");
                }
                sb.append(" AS\n" + source.fieldByName("PROCEDURE_SOURCE").getString());
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createFunction(String objectName) {
        Query source = this.database.createQuery();
        try {
            source.setSqlText(Sql.getFunctionSimpleArgumentList());
            source.paramByName("FUNCTION_NAME").setString(objectName);
            source.open();
            StringBuilder paramIn = new StringBuilder();
            StringBuilder paramOut = new StringBuilder();
            while (!source.eof()) {
                if (source.fieldByName("ARGUMENT_POSITION").getInteger() == 0) {
                    paramOut.append(source.fieldByName("DISPLAY_TYPE").getString());
                    if (source.fieldByName("FIELD_TYPE").getInteger() == 40) {
                        paramOut.append(" FREE_IT");
                    } else {
                        paramOut.append(" BY VALUE");
                    }
                } else {
                    if (paramIn.length() > 0) {
                        paramIn.append(", ");
                    }
                    paramIn.append(source.fieldByName("DISPLAY_TYPE").getString());
                }
                source.next();
            }
            source.close();
            source.setSqlText(Sql.getFunctionSource());
            source.paramByName("FUNCTION_NAME").setString(objectName);
            source.open();
            StringBuilder sb = new StringBuilder();
            if (!source.eof()) {
                sb.append("DECLARE EXTERNAL FUNCTION " + objectName);
                if (paramIn.length() > 0) {
                    sb.append("\n  " + paramIn.toString());
                }
                if (paramOut.length() > 0) {
                    sb.append("\n  RETURNS " + paramOut.toString());
                }
                sb.append("\n  ENTRY_POINT '" + source.fieldByName("ENTRYPOINT").getString() + "' MODULE_NAME '" + source.fieldByName("LIB_NAME").getString() + "'");
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            source.close();
        }
        return null;
    }
}

