/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import pl.mpak.orbada.db.DriverType;
import pl.mpak.orbada.db.Utils;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class Driver
extends DefaultBufferedRecord {
    public Driver(Database database) {
        super(database, "DRIVERS", "DRV_ID");
        this.add("DRV_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("DRV_USR_ID", 11, true);
        this.add("DRV_NAME", 11, true);
        this.add("DRV_LIBRARY_SOURCE", 11, true);
        this.add("DRV_TYPE_NAME", 11, true);
        this.add("DRV_CLASS_NAME", 11, true);
        this.add("DRV_URL_TEMPLATE", 11, true);
        this.add("DRV_EXTRA_LIBRARY", 11, true);
    }

    public Driver(Database database, String drv_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(drv_id));
    }

    public String getId() {
        return this.fieldByName("DRV_ID").getValue().toString();
    }

    public void setId(String id) {
        this.fieldByName("DRV_ID").setString(id);
    }

    public String getUsrId() {
        if (this.fieldByName("DRV_USR_ID").isNull()) {
            return null;
        }
        return this.fieldByName("DRV_USR_ID").getValue().toString();
    }

    public void setUsrId(String id) {
        this.fieldByName("DRV_USR_ID").setString(id);
    }

    public DriverType getDriverType() throws UseDBException {
        DriverType dt = new DriverType(this.getDatabase());
        dt.loadRecordBy("DTP_NAME", this.fieldByName("DRV_TYPE_NAME").getValue());
        return dt;
    }

    public String replacePatts(String templateUrl) {
        String text = templateUrl;
        text = Utils.replace(text, "drivertype", this.fieldByName("DRV_TYPE_NAME").getValue().toString());
        text = Utils.replace(text, "drivername", this.fieldByName("DRV_NAME").getValue().toString());
        text = Utils.replace(text, "driver", this.fieldByName("DRV_NAME").getValue().toString());
        return text;
    }
}

