/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class Gadget
extends DefaultBufferedRecord {
    public Gadget(Database database) {
        super(database, "GADGETS", "GDG_ID");
        this.add("GDG_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("GDG_PPS_ID", 11, true);
        this.add("GDG_ORDER", 3, true);
        this.add("GDG_NAME", 11, true);
        this.add("GDG_MINIMIZED", 11, true);
        this.add("GDG_HEIGHT", 3, true);
    }

    public Gadget(Database database, String gdg_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(gdg_id));
    }

    public String getPpsId() {
        try {
            return this.fieldByName("gdg_pps_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setPpsId(String ppsId) {
        this.fieldByName("gdg_pps_id").setString(ppsId);
    }

    public Integer getOrder() {
        if (this.fieldByName("gdg_order").isNull()) {
            return null;
        }
        try {
            return this.fieldByName("gdg_order").getInteger();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setOrder(Integer order) {
        if (order == null) {
            this.fieldByName("gdg_order").clear();
        } else {
            this.fieldByName("gdg_order").setInteger(order.intValue());
        }
    }

    public String getGdgId() {
        try {
            return this.fieldByName("gdg_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setGdgId(String gdgId) {
        this.fieldByName("gdg_id").setString(gdgId);
    }

    public String getName() {
        try {
            return this.fieldByName("gdg_name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return "???";
        }
    }

    public void setName(String name) {
        this.fieldByName("gdg_name").setString(name);
    }

    public boolean isMinimized() {
        try {
            return StringUtil.toBoolean((String)this.fieldByName("gdg_minimized").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return false;
        }
    }

    public void setMinimized(boolean value) {
        this.fieldByName("gdg_minimized").setString(value ? "T" : "F");
    }

    public Integer getHeight() {
        if (this.fieldByName("gdg_height").isNull()) {
            return null;
        }
        try {
            return this.fieldByName("gdg_height").getInteger();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setHeight(Integer height) {
        if (height == null) {
            this.fieldByName("gdg_height").clear();
        } else {
            this.fieldByName("gdg_height").setInteger(height.intValue());
        }
    }
}

