/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class OrbadaSession
extends DefaultBufferedRecord {
    public OrbadaSession(Database database) {
        super(database, "ORBADA_SESSIONS", "OSES_ID");
        this.add("OSES_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("OSES_START_TIME", 20, true);
        this.add("OSES_END_TIME", 20, true);
        this.add("OSES_VERSION", 11, true);
        this.add("OSES_USR_ID", 11, true);
        this.add("OSES_TERMINAL", 11, true);
    }

    public OrbadaSession(Database database, String gdg_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(gdg_id));
    }

    public String getId() {
        try {
            return this.fieldByName("OSES_ID").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setId(String ppsId) {
        this.fieldByName("OSES_ID").setString(ppsId);
    }

    public Long getStartTime() {
        try {
            return this.fieldByName("OSES_START_TIME").getLong();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setStartTime(Long startTime) {
        this.fieldByName("OSES_START_TIME").setLong(startTime.longValue());
    }

    public void setStartTime(String startTime) {
        this.fieldByName("OSES_START_TIME").setString(startTime);
    }

    public Long getEndTime() {
        try {
            return this.fieldByName("OSES_END_TIME").getLong();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setEndTime(Long endTime) {
        this.fieldByName("OSES_END_TIME").setLong(endTime.longValue());
    }

    public void setEndTime(String endTime) {
        this.fieldByName("OSES_END_TIME").setString(endTime);
    }

    public String getUsrId() {
        try {
            return this.fieldByName("OSES_USR_ID").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setUsrId(String id) {
        this.fieldByName("OSES_USR_ID").setString(id);
    }

    public String getVersion() {
        try {
            return this.fieldByName("OSES_VERSION").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setVersion(String version) {
        this.fieldByName("OSES_VERSION").setString(version);
    }

    public String getTerminal() {
        try {
            return this.fieldByName("OSES_TERMINAL").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setTerminal(String terminal) {
        this.fieldByName("OSES_TERMINAL").setString(terminal);
    }
}

