/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class Perspective
extends DefaultBufferedRecord {
    public Perspective(Database database) {
        super(database, "PERSPECTIVES", "PPS_ID");
        this.add("PPS_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("PPS_USR_ID", 11, true);
        this.add("PPS_SCH_ID", 11, true);
        this.add("PPS_NAME", 11, true);
        this.add("PPS_DESCRIPTION", 11, true);
        this.add("PPS_DEFAULT", 11, true);
        this.add("PPS_VIEW_COUNT", new Variant(0), 3, true);
        this.add("PPS_GADGET_COUNT", new Variant(0), 3, true);
        this.add("PPS_GADGETS_WIDTH", new Variant(150), 3, true);
    }

    public Perspective(Database database, String ppr_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(ppr_id));
    }

    public String getPpsId() {
        try {
            return this.fieldByName("pps_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setPpsId(String usrId) {
        this.fieldByName("pps_id").setString(usrId);
    }

    public String getUsrId() {
        try {
            return this.fieldByName("pps_usr_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setUsrId(String usrId) {
        this.fieldByName("pps_usr_id").setString(usrId);
    }

    public String getSchId() {
        try {
            return this.fieldByName("pps_sch_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setSchId(String schId) {
        this.fieldByName("pps_sch_id").setString(schId);
    }

    public String getName() {
        try {
            return this.fieldByName("pps_name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return "???";
        }
    }

    public void setName(String name) {
        this.fieldByName("pps_name").setString(name);
    }

    public String getDisplayName(Database database) {
        String name = this.getName();
        if (database != null) {
            name = StringUtil.replaceString((String)name, (String)"$(public-name)", (String)database.getPublicName());
            name = StringUtil.replaceString((String)name, (String)"$(user-name)", (String)database.getUserName());
            name = StringUtil.replaceString((String)name, (String)"$(server-name)", (String)database.getServerName());
            name = StringUtil.replaceString((String)name, (String)"$(driver-name)", (String)database.getDriverType());
        }
        return name;
    }

    public String getDescription() {
        try {
            return this.fieldByName("pps_description").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setDescription(String description) {
        this.fieldByName("pps_description").setString(description);
    }

    public boolean isDefault() {
        try {
            return StringUtil.toBoolean((String)this.fieldByName("pps_default").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return false;
        }
    }

    public void setDefault(boolean defaultValue) {
        this.fieldByName("pps_default").setString(defaultValue ? "T" : "F");
    }

    public int getViewCount() {
        try {
            return this.fieldByName("pps_view_count").getInteger();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return 0;
        }
    }

    public void setViewCount(int viewCount) {
        this.fieldByName("pps_view_count").setInteger(viewCount);
    }

    public int getGadgetCount() {
        try {
            return this.fieldByName("pps_gadget_count").getInteger();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return 0;
        }
    }

    public void setGadgetCount(int gadgetCount) {
        this.fieldByName("pps_gadget_count").setInteger(gadgetCount);
    }

    public int getGadgetsWidth() {
        try {
            return this.fieldByName("pps_gadgets_width").getInteger();
        }
        catch (VariantException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return 0;
        }
    }

    public void setGadgetsWidth(int gadgetsWidth) {
        this.fieldByName("pps_gadgets_width").setInteger(gadgetsWidth);
    }
}

