/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pl.mpak.orbada.db.Driver;
import pl.mpak.orbada.db.Utils;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;
import pl.mpak.util.variant.VariantException;

public class Schema
extends DefaultBufferedRecord {
    private Icon icon;
    private Driver driver;

    public Schema(Database database) {
        super(database, "SCHEMAS", "SCH_ID");
        this.add("SCH_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("SCH_USR_ID", 11, true);
        this.add("SCH_NAME", 11, true);
        this.add("SCH_DRV_ID", 11, true);
        this.add("SCH_HOST", 11, true);
        this.add("SCH_DATABASE", 11, true);
        this.add("SCH_USER", 11, true);
        this.add("SCH_PASSWORD", 11, true);
        this.add("SCH_PORT", 3, true);
        this.add("SCH_URL", 11, true);
        this.add("SCH_AUTO_COMMIT", 11, true);
        this.add("SCH_SELECTED", 20, true);
        this.add("SCH_DB_VERSION", 11, true);
        this.add("SCH_ICON", 13, true);
        this.add("SCH_PROPERTIES", 11, true);
        this.add("SCH_USER_PROPERTIES", 11, true);
        this.add("SCH_PUBLIC_NAME", 11, true);
    }

    public Schema(Database database, String sch_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(sch_id));
    }

    public String getSchId() {
        try {
            return this.fieldByName("sch_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setSchId(String id) {
        this.fieldByName("SCH_ID").setString(id);
    }

    public String getUsrId() {
        if (this.fieldByName("SCH_USR_ID").isNull()) {
            return null;
        }
        return this.fieldByName("SCH_USR_ID").getValue().toString();
    }

    public void setUsrId(String id) {
        this.fieldByName("SCH_USR_ID").setString(id);
    }

    public String getHost() {
        if (this.fieldByName("SCH_HOST").isNull()) {
            return null;
        }
        return this.fieldByName("SCH_HOST").getValue().toString();
    }

    public void setHost(String host) {
        this.fieldByName("SCH_HOST").setString(host);
    }

    public Integer getPort() {
        if (this.fieldByName("SCH_PORT").isNull()) {
            return null;
        }
        try {
            return this.fieldByName("SCH_PORT").getInteger();
        }
        catch (VariantException ex) {
            return null;
        }
    }

    public void setPort(Integer port) {
        this.fieldByName("SCH_PORT").setInteger(port.intValue());
    }

    public void setPort(String port) {
        this.fieldByName("SCH_PORT").setString(port);
    }

    public String getUser() {
        if (this.fieldByName("SCH_USER").isNull()) {
            return null;
        }
        return this.fieldByName("SCH_USER").getValue().toString();
    }

    public void setUser(String user) {
        this.fieldByName("SCH_USER").setString(user);
    }

    public String getPassword() {
        if (this.fieldByName("SCH_PASSWORD").isNull()) {
            return null;
        }
        return this.fieldByName("SCH_PASSWORD").getValue().toString();
    }

    public void setPassword(String password) {
        this.fieldByName("SCH_PASSWORD").setString(password);
    }

    public String getDatabaseName() {
        if (this.fieldByName("SCH_DATABASE").isNull()) {
            return null;
        }
        return this.fieldByName("SCH_DATABASE").getValue().toString();
    }

    public void setDatabaseName(String database) {
        this.fieldByName("SCH_DATABASE").setString(database);
    }

    public String getDrvId() {
        try {
            return this.fieldByName("SCH_DRV_ID").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setDrvId(String id) {
        this.fieldByName("SCH_DRV_ID").setString(id);
        this.driver = null;
    }

    public String getUrl() {
        try {
            return this.fieldByName("SCH_URL").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setUrl(String url) {
        this.fieldByName("SCH_URL").setString(url);
    }

    public String getPropertiesAsString() {
        if (this.fieldByName("SCH_PROPERTIES").isNull()) {
            return null;
        }
        try {
            return this.fieldByName("SCH_PROPERTIES").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public Properties getProperties() {
        if (this.fieldByName("SCH_PROPERTIES").isNull()) {
            return null;
        }
        try {
            StringReader reader = new StringReader(this.fieldByName("SCH_PROPERTIES").getString());
            Properties result = new Properties();
            result.load(reader);
            reader.close();
            return result;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setProperties(String props) {
        this.fieldByName("SCH_PROPERTIES").setString(props);
    }

    public void setProperties(Properties props) {
        if (props != null) {
            StringWriter writer = new StringWriter();
            try {
                props.store(writer, null);
                this.fieldByName("SCH_PROPERTIES").setString(writer.toString());
                writer.close();
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
                this.fieldByName("SCH_PROPERTIES").setValue(null);
            }
        } else {
            this.fieldByName("SCH_PROPERTIES").setValue(null);
        }
    }

    public String getUserPropertiesAsString() {
        if (this.fieldByName("SCH_USER_PROPERTIES").isNull()) {
            return null;
        }
        try {
            return this.fieldByName("SCH_USER_PROPERTIES").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public Properties getUserProperties() {
        if (this.fieldByName("SCH_USER_PROPERTIES").isNull()) {
            return null;
        }
        try {
            StringReader reader = new StringReader(this.fieldByName("SCH_USER_PROPERTIES").getString());
            Properties result = new Properties();
            result.load(reader);
            reader.close();
            return result;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setUserProperties(String props) {
        this.fieldByName("SCH_USER_PROPERTIES").setString(props);
    }

    public void setUserProperties(Properties props) {
        if (props != null) {
            StringWriter writer = new StringWriter();
            try {
                props.store(writer, null);
                this.fieldByName("SCH_USER_PROPERTIES").setString(writer.toString());
                writer.close();
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
                this.fieldByName("SCH_USER_PROPERTIES").setValue(null);
            }
        } else {
            this.fieldByName("SCH_USER_PROPERTIES").setValue(null);
        }
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (!this.fieldByName("sch_icon").getValue().isNullValue()) {
            try {
                this.icon = new ImageIcon(this.fieldByName("sch_icon").getValue().getBinary());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            return this.icon;
        }
        return null;
    }

    public Driver getDriver() throws UseDBException {
        if (this.driver == null) {
            this.driver = new Driver(this.getDatabase(), this.fieldByName("SCH_DRV_ID").getValue().toString());
        }
        return this.driver;
    }

    public void applyInsert() throws Exception {
        this.fieldByName("SCH_PUBLIC_NAME").setString(this.getPublicNameResolved());
        super.applyInsert();
    }

    public void applyUpdate() throws Exception {
        this.fieldByName("SCH_PUBLIC_NAME").setString(this.getPublicNameResolved());
        super.applyUpdate();
    }

    public String replacePatts(String templateUrl) {
        String text = templateUrl;
        text = Utils.replace(text, "host", this.fieldByName("SCH_HOST").getValue().toString());
        if (!this.fieldByName("SCH_PORT").isNull()) {
            try {
                text = Utils.replace(text, "port", this.fieldByName("SCH_PORT").getValue().cast(3).toString());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        text = Utils.replace(text, "database", this.fieldByName("SCH_DATABASE").getValue().toString());
        text = Utils.replace(text, "sid", this.fieldByName("SCH_DATABASE").getValue().toString());
        text = Utils.replace(text, "db", this.fieldByName("SCH_DATABASE").getValue().toString());
        text = Utils.replace(text, "user", this.fieldByName("SCH_USER").getValue().toString());
        text = Utils.replace(text, "username", this.fieldByName("SCH_USER").getValue().toString());
        text = text.replaceAll("\\[.*\\]", "");
        return text;
    }

    public String getPublicNameResolved() {
        String text = this.replacePatts(this.fieldByName("SCH_NAME").getValue().toString());
        try {
            if (!this.fieldByName("sch_drv_id").getValue().isNullValue()) {
                text = this.getDriver().replacePatts(text);
            }
        }
        catch (UseDBException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        return text;
    }

    public String getPublicNameResolved(String userName) {
        String text = this.fieldByName("SCH_NAME").getValue().toString();
        text = Utils.replace(text, "user", userName);
        text = Utils.replace(text, "username", userName);
        text = this.replacePatts(text);
        try {
            if (!this.fieldByName("sch_drv_id").getValue().isNullValue()) {
                text = this.getDriver().replacePatts(text);
            }
        }
        catch (UseDBException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        return text;
    }
}

