/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import java.util.Map;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.patt.Resolvers;
import pl.mpak.util.variant.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template
extends DefaultBufferedRecord {
    public Template(Database database) {
        super(database, "TEMPLATES", "TPL_ID");
        this.add("TPL_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("TPL_USR_ID", 11, true);
        this.add("TPL_NAME", 11, true);
        this.add("TPL_DESCRIPTION", 11, true);
        this.add("TPL_BODY", 11, true);
    }

    public Template(Database database, String tpl_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(tpl_id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Template loadByName(String name) {
        try {
            Query query = new Query(this.getDatabase());
            query.setSqlText("select templates.*, case when tpl_usr_id is null then 0 else 1 end ordering from templates where tpl_name = :tpl_name order by ordering");
            query.paramByName("tpl_name").setString(name);
            try {
                query.open();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
                return null;
            }
            try {
                if (!query.eof()) {
                    this.updateFrom(query);
                    return this;
                }
                Template template = null;
                return template;
            }
            finally {
                query.close();
            }
        }
        catch (UseDBException ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public String getTplId() {
        try {
            return this.fieldByName("tpl_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setTplId(String usrId) {
        this.fieldByName("tpl_id").setString(usrId);
    }

    public String getUsrId() {
        try {
            return this.fieldByName("tpl_usr_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setUsrId(String usrId) {
        this.fieldByName("tpl_usr_id").setString(usrId);
    }

    public String getName() {
        try {
            return this.fieldByName("tpl_name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return "???";
        }
    }

    public void setName(String name) {
        this.fieldByName("tpl_name").setString(name);
    }

    public String getDescription() {
        try {
            return this.fieldByName("tpl_description").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setDescription(String description) {
        this.fieldByName("tpl_description").setString(description);
    }

    public String getBody() {
        try {
            return this.fieldByName("tpl_body").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setBody(String body) {
        this.fieldByName("tpl_body").setString(body);
    }

    public String expand(Map<String, String> values) {
        return Resolvers.expand((String)this.getBody(), values);
    }
}

