/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class Tool
extends DefaultBufferedRecord {
    protected static Interpreter interpreter = new Interpreter();
    private Icon icon;

    public Tool(Database database) {
        super(database, "TOOLS", "TO_ID");
        this.add("TO_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("TO_USR_ID", 11, true);
        this.add("TO_COMMAND", 11, true);
        this.add("TO_SOURCE", 11, true);
        this.add("TO_ARGUMENTS", 11, true);
        this.add("TO_TITLE", 11, true);
        this.add("TO_MENU", 11, true);
        this.add("TO_TOOLBUTTON", 11, true);
        this.add("TO_BSH_GET_ARGUMENTS", 11, true);
        this.add("TO_BSH_BEFORE_EXEC", 11, true);
        this.add("TO_BSH_AFTER_EXEC", 11, true);
        this.add("TO_ICON", 13, true);
    }

    public Tool(Database database, String to_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(to_id));
    }

    public String getUsrId() {
        return this.fieldByName("TO_USR_ID").getValue().toString();
    }

    public void setUsrId(String id) {
        this.fieldByName("TO_USR_ID").setString(id);
    }

    public String getCommand() {
        return this.fieldByName("to_command").getValue().toString();
    }

    public String getSource() {
        return this.fieldByName("to_source").getValue().toString();
    }

    public String getTitle() {
        return this.fieldByName("to_title").getValue().toString();
    }

    public String getArguments() {
        return this.fieldByName("to_arguments").getValue().toString();
    }

    public String getBshGetArguments() {
        return this.fieldByName("to_bsh_get_arguments").getValue().toString();
    }

    public String getBshBeforeExec() {
        return this.fieldByName("to_bsh_before_exec").getValue().toString();
    }

    public String getBshAfterExec() {
        return this.fieldByName("to_bsh_after_exec").getValue().toString();
    }

    public boolean isMenu() {
        return "Y".equals(this.fieldByName("to_menu").getValue().toString());
    }

    public boolean isToolButton() {
        return "Y".equals(this.fieldByName("to_toolbutton").getValue().toString());
    }

    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (!this.fieldByName("to_icon").getValue().isNullValue()) {
            try {
                this.icon = new ImageIcon(this.fieldByName("to_icon").getValue().getBinary());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            return this.icon;
        }
        return null;
    }

    private String bshArguments() {
        String cmd = this.getBshGetArguments();
        if (!StringUtil.isEmpty((String)cmd)) {
            try {
                Object o = interpreter.eval(cmd);
                if (o != null) {
                    return o.toString();
                }
                return null;
            }
            catch (EvalError ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        return "";
    }

    private void bshBeforeExec() {
        String cmd = this.getBshBeforeExec();
        if (!StringUtil.isEmpty((String)cmd)) {
            try {
                Object o = interpreter.eval(cmd);
                interpreter.set("result", o);
            }
            catch (EvalError ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void bshAfterExec() {
        String cmd = this.getBshAfterExec();
        if (!StringUtil.isEmpty((String)cmd)) {
            try {
                interpreter.eval(cmd);
            }
            catch (EvalError ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(Database activeDatabase, Object[] args) {
        String arguments = "";
        if (args != null) {
            arguments = String.format(this.getArguments(), args);
        }
        try {
            if (activeDatabase != null) {
                interpreter.set("database", (Object)activeDatabase);
            } else {
                interpreter.set("database", null);
            }
        }
        catch (EvalError ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        String bshArguments = this.bshArguments();
        if (bshArguments == null) {
            return;
        }
        try {
            this.bshBeforeExec();
            String source = this.getSource();
            if (!StringUtil.isEmpty((String)source)) {
                Runtime.getRuntime().exec(source + " " + arguments + " " + bshArguments);
            }
        }
        catch (IOException ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show(null, (String)"B\u0142\u0105d", (String)ex.getMessage(), (int)1, (int)0);
        }
        finally {
            this.bshAfterExec();
        }
    }
}

