/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class User
extends DefaultBufferedRecord {
    public User(Database database) {
        super(database, "USERS", "USR_ID");
        this.add("USR_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("USR_CREATED", 20, true);
        this.add("USR_UPDATED", 20, true);
        this.add("USR_NAME", 11, true);
        this.add("USR_PASSWORD", 11, true);
        this.add("USR_DESCRIPTION", 11, true);
        this.add("USR_ADMIN", 11, true);
        this.add("USR_ORBADA", 11, true);
        this.add("USR_ACTIVE", new Variant("T"), 11, true);
        this.add("USR_REGISTERED", 11, true);
    }

    public User(Database database, String usr_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(usr_id));
    }

    public String getUserName() {
        return this.fieldByName("usr_name").getValue().toString();
    }

    public void setUserName(String userName) {
        this.fieldByName("usr_name").setValue(new Variant(userName.toLowerCase()));
    }

    public String getUserId() {
        return this.fieldByName("usr_id").getValue().toString();
    }

    public void setUserId(String id) {
        this.fieldByName("usr_id").setString(id);
    }

    public String getPassword() {
        return this.fieldByName("usr_password").getValue().toString();
    }

    public void setPassword(String password) {
        this.fieldByName("usr_password").setValue(new Variant(password));
    }

    public boolean isUserAdmin() {
        return "Y".equals(this.fieldByName("usr_admin").getValue().toString());
    }

    public void setActive(String value) {
        this.fieldByName("usr_active").setValue(new Variant(value));
    }

    public boolean isActive() {
        return "T".equals(this.fieldByName("usr_active").getValue().toString());
    }

    public void setRegistered(String value) {
        this.fieldByName("usr_registered").setString(value);
    }

    public void setRegistered(boolean value) {
        this.fieldByName("usr_registered").setString(value ? "T" : "F");
    }

    public boolean isRegistered() {
        return "T".equals(this.fieldByName("usr_registered").getValue().toString());
    }

    public void applyInsert() throws Exception {
        if (!this.fieldByName("USR_CREATED").isChanged()) {
            this.fieldByName("USR_CREATED").setValue(new Variant(System.currentTimeMillis()));
        }
        if (!this.fieldByName("USR_UPDATED").isChanged()) {
            this.fieldByName("USR_UPDATED").setLong(System.currentTimeMillis());
        }
        super.applyInsert();
        this.getDatabase().executeCommand("insert into tools (to_usr_id, to_id, to_command, to_source, to_arguments, to_title, to_menu)\nvalues ('" + this.fieldByName("usr_id").getValue().toString() + "', '" + UniqueID.next() + "', 'notepad-run', 'javaw -jar tools/jfc-notepad-1.0.0.jar', null, 'Notatnik', 'Y')");
        this.getDatabase().executeCommand("insert into tools (to_usr_id, to_id, to_command, to_source, to_arguments, to_title, to_menu)\nvalues ('" + this.fieldByName("usr_id").getValue().toString() + "', '" + UniqueID.next() + "', 'notepad', 'javaw -jar tools/jfc-notepad-1.0.0.jar', '\"-open:%s\"', 'Notatnik', 'N')");
    }

    public void applyUpdate() throws Exception {
        if (!this.fieldByName("USR_UPDATED").isChanged()) {
            this.fieldByName("USR_UPDATED").setLong(System.currentTimeMillis());
        }
        super.applyUpdate();
    }
}

