/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.db;

import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.br.DefaultBufferedRecord;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.variant.Variant;

public class View
extends DefaultBufferedRecord {
    public View(Database database) {
        super(database, "VIEWS", "VWS_ID");
        this.add("VWS_ID", new Variant(new UniqueID().toString()), 11, false);
        this.add("VWS_PPS_ID", 11, true);
        this.add("VWS_ORDER", 3, true);
        this.add("VWS_NAME", 11, true);
        this.add("VWS_HIDE_TITLE", 11, true);
        this.add("VWS_HIDE_ICON", 11, true);
    }

    public View(Database database, String vws_id) throws UseDBException {
        this(database);
        this.loadRecord(new Variant(vws_id));
    }

    public String getPpsId() {
        try {
            return this.fieldByName("vws_pps_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setPpsId(String ppsId) {
        this.fieldByName("vws_pps_id").setString(ppsId);
    }

    public Integer getOrder() {
        if (this.fieldByName("vws_order").isNull()) {
            return null;
        }
        try {
            return this.fieldByName("vws_order").getInteger();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setOrder(Integer order) {
        if (order == null) {
            this.fieldByName("vws_order").clear();
        } else {
            this.fieldByName("vws_order").setInteger(order.intValue());
        }
    }

    public String getVwsId() {
        try {
            return this.fieldByName("vws_id").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return null;
        }
    }

    public void setVwsId(String schId) {
        this.fieldByName("vws_id").setString(schId);
    }

    public String getName() {
        try {
            return this.fieldByName("vws_name").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return "???";
        }
    }

    public void setName(String name) {
        this.fieldByName("vws_name").setString(name);
    }

    public boolean isHideTitle() {
        try {
            return StringUtil.toBoolean((String)this.fieldByName("vws_hide_title").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return false;
        }
    }

    public void setHideTitle(boolean defaultValue) {
        this.fieldByName("vws_hide_title").setString(defaultValue ? "T" : "F");
    }

    public boolean isHideIcon() {
        try {
            return StringUtil.toBoolean((String)this.fieldByName("vws_hide_icon").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            return false;
        }
    }

    public void setHideIcon(boolean defaultValue) {
        this.fieldByName("vws_hide_icon").setString(defaultValue ? "T" : "F");
    }
}

