/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.export.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.JTable;
import pl.mpak.orbada.export.pdf.ExportToPdfDialog;
import pl.mpak.orbada.export.pdf.OrbadaExportPdfPlugin;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.providers.ExportTableActionProvider;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ExportToPdf
extends ExportTableActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaExportPdfPlugin.class);
    private String nullDataValue;
    private String fileName;
    private String charset;
    private String pageSize;

    public ExportToPdf() {
        this.setText(this.stringManager.getString("ExportToPdf-text"));
        this.setActionCommandKey("ExportToPdf");
        this.addActionListener(this.createActionListener());
    }

    public String getDescription() {
        return this.stringManager.getString("ExportToPdf-description");
    }

    private ISettings getConfig() {
        return this.application.getSettings("export-to-pdf-file");
    }

    private void localConfig() {
        try {
            this.nullDataValue = this.getConfig().getValue("null-data-value").getString();
            this.charset = this.getConfig().getValue("charset").getString();
            this.fileName = this.getConfig().getValue("file-name").getString();
            this.pageSize = this.getConfig().getValue("page-size").getString();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private int[] getColumnWidths(JTable table) {
        int[] array = new int[table.getColumnCount()];
        for (int i = 0; i < table.getColumnCount(); ++i) {
            array[i] = (int)((double)table.getColumnModel().getColumn(i).getWidth() / (double)table.getWidth() * 100.0);
        }
        return array;
    }

    private void exportTable(JTable table) {
        try {
            Document document = "A1".equals(this.pageSize) ? new Document(PageSize.A1.rotate(), 10.0f, 10.0f, 10.0f, 10.0f) : ("A2".equals(this.pageSize) ? new Document(PageSize.A2.rotate(), 10.0f, 10.0f, 10.0f, 10.0f) : ("A3".equals(this.pageSize) ? new Document(PageSize.A3.rotate(), 10.0f, 10.0f, 10.0f, 10.0f) : ("A4".equals(this.pageSize) ? new Document(PageSize.A4.rotate(), 10.0f, 10.0f, 10.0f, 10.0f) : ("A5".equals(this.pageSize) ? new Document(PageSize.A5.rotate(), 10.0f, 10.0f, 10.0f, 10.0f) : new Document(PageSize.A4.rotate(), 10.0f, 10.0f, 10.0f, 10.0f)))));
            document.addAuthor(this.application.getUserName());
            document.addSubject("Orbada Data Export Plugin");
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(this.fileName));
            document.open();
            BaseFont bf = BaseFont.createFont((String)"Times-Roman", (String)"Cp1250", (boolean)true);
            Font stringFont = new Font(bf, 12.0f, 0, QueryTableCellRenderer.stringColor);
            Font boolFont = new Font(bf, 12.0f, 0, QueryTableCellRenderer.boolColor);
            Font dateFont = new Font(bf, 12.0f, 0, QueryTableCellRenderer.dateColor);
            Font numberFont = new Font(bf, 12.0f, 0, QueryTableCellRenderer.numberColor);
            Font nullFont = new Font(bf, 12.0f, 0, QueryTableCellRenderer.nullColor);
            PdfPTable datatable = new PdfPTable(table.getColumnCount());
            datatable.getDefaultCell().setPadding(3.0f);
            datatable.setWidths(this.getColumnWidths(table));
            datatable.setWidthPercentage(100.0f);
            datatable.getDefaultCell().setBorderWidth(2.0f);
            datatable.getDefaultCell().setHorizontalAlignment(1);
            for (int c = 0; c < table.getColumnCount(); ++c) {
                Phrase ph = new Phrase(new String(table.getColumnModel().getColumn(c).getHeaderValue().toString().getBytes(), this.charset), stringFont);
                datatable.addCell(ph);
            }
            datatable.setHeaderRows(1);
            datatable.getDefaultCell().setBorderWidth(1.0f);
            for (int r = 0; r < table.getRowCount(); ++r) {
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    Object o = table.getValueAt(r, c);
                    Variant v = o instanceof Variant ? (Variant)o : new Variant(o);
                    Font f = stringFont;
                    if (v.isNullValue()) {
                        f = nullFont;
                    } else if (v.getValue() instanceof Number) {
                        f = numberFont;
                    } else if (v.getValue() instanceof Date) {
                        f = dateFont;
                    } else if (v.getValue() instanceof Boolean) {
                        f = boolFont;
                    }
                    Phrase ph = "".equals(v.toString()) ? new Phrase(new String(this.nullDataValue.getBytes(), this.charset), f) : new Phrase(new String(v.toString().getBytes(), this.charset), f);
                    PdfPCell cell = new PdfPCell(ph);
                    if (!v.isNullValue() && v.getValue() instanceof Number) {
                        cell.setHorizontalAlignment(2);
                    } else if (!v.isNullValue() && v.getValue() instanceof Date) {
                        cell.setHorizontalAlignment(1);
                    } else {
                        cell.setHorizontalAlignment(0);
                    }
                    datatable.addCell(cell);
                }
            }
            document.add((Element)datatable);
            document.close();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)null, (String)"B\u0142\u0105d", (String)ex.getMessage(), (int[])new int[]{1});
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JTable table = ExportToPdf.this.getTable(event);
                if (table != null && ExportToPdfDialog.showDialog(ExportToPdf.this.getConfig())) {
                    ExportToPdf.this.localConfig();
                    ExportToPdf.this.exportTable(table);
                }
            }
        };
    }

    public String getGroupName() {
        return "Export tools";
    }
}

