/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.octopuspw.services;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import pl.mpak.orbada.octopuspw.OrbadaOctopusPleaseWaitPlugin;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.providers.PleaseWaitRendererProvider;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OctopusPleaseWaitRenderer
extends PleaseWaitRendererProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOctopusPleaseWaitPlugin.class);
    private static final int WAIT_X_SHIFT = 40;
    private static final int WAIT_Y_SHIFT = 10;
    public static final String uniqueId = "orbada-octopus-please-wait-renderer";
    private Rectangle renderRectangle;
    private Image waitImage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/orbada/octopuspw/res/octopus.gif")).getImage();

    public void control() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Graphics2D g2, PleaseWait[] waitArr) {
        OctopusPleaseWaitRenderer octopusPleaseWaitRenderer = this;
        synchronized (octopusPleaseWaitRenderer) {
            int yShift = 0;
            FontMetrics fm = g2.getFontMetrics();
            for (PleaseWait wait : waitArr) {
                if (wait.getMessage() == null) continue;
                yShift += fm.getHeight() + 4;
            }
            int left = this.component.getWidth() - 40;
            int top = this.component.getHeight() - 10 - yShift;
            if (this.waitImage != null) {
                g2.drawImage(this.waitImage, left - this.waitImage.getWidth(null), top - this.waitImage.getHeight(null), null);
            }
            yShift = 0;
            for (PleaseWait wait : waitArr) {
                if (wait.getMessage() == null) continue;
                g2.drawString(wait.getMessage(), left - (this.waitImage.getWidth(null) + fm.stringWidth(wait.getMessage())) / 2, top);
                top += fm.getHeight() + 1;
            }
        }
    }

    public String getDescription() {
        return stringManager.getString("OctopusPleaseWaitRenderer-description");
    }

    public String getGroupName() {
        return "OrbadaOctopusPleaseWait";
    }

    public String getRendererId() {
        return uniqueId;
    }

    public Rectangle getRenderBounds() {
        return this.renderRectangle;
    }
}

