/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.SearchEvent;
import pl.mpak.sky.gui.swing.comp.SearchListener;
import pl.mpak.sky.gui.swing.comp.SearchPanel;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ParametersPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private SearchPanel searchPanel;

    public ParametersPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.searchPanel = new SearchPanel();
        this.searchPanel.setTable(this.getTable());
        this.searchPanel.addSearchListener(new SearchListener(){

            public void search(SearchEvent e) {
                ParametersPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.searchPanel);
        super.init();
    }

    public Component getTabbedPane() {
        return null;
    }

    public String getCurrentSchemaName() {
        return null;
    }

    public String getPanelName() {
        return "oracle-database-parameters";
    }

    public String getSchemaColumnName() {
        return null;
    }

    public String getObjectColumnName() {
        return "name";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        ArrayList<QueryTableColumn> columns = new ArrayList<QueryTableColumn>();
        QueryTableCellRenderer renderer = new QueryTableCellRenderer(){
            HashMap map = new HashMap();
            {
                this.map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                QueryTableColumn tc = (QueryTableColumn)table.getColumnModel().getColumn(column);
                if ("name".equalsIgnoreCase(tc.getFieldName())) {
                    label.setFont(label.getFont().deriveFont(1));
                } else if ("display_type".equalsIgnoreCase(tc.getFieldName())) {
                    label.setForeground(SwingUtil.Color.GREEN);
                }
                try {
                    if (StringUtil.toBoolean((String)ParametersPanelView.this.getQuery().fieldByName("isdeprecated").getString())) {
                        label.setFont(label.getFont().deriveFont(this.map));
                    }
                    if (!isSelected && !"false".equalsIgnoreCase(ParametersPanelView.this.getQuery().fieldByName("ismodified").getString())) {
                        label.setBackground(new Color(200, 200, 250));
                    }
                }
                catch (Exception ex) {
                    label.setText(label.getText() + " [" + ex.getMessage() + "]");
                }
                return label;
            }
        };
        if (StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("rac-detect", "false"))) {
            columns.add(new QueryTableColumn("inst_id", this.stringManager.getString("instance"), 30, (TableCellRenderer)renderer));
        }
        columns.add(new QueryTableColumn("num", this.stringManager.getString("num"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("name", this.stringManager.getString("name"), 200, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("display_type", this.stringManager.getString("display-param-type"), 70, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("display_value", this.stringManager.getString("display-param-value"), 250, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("isdefault", this.stringManager.getString("is-default"), 60, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("ismodified", this.stringManager.getString("is-modified"), 60, (TableCellRenderer)renderer));
        if (StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("rac-detect", "false"))) {
            columns.add(new QueryTableColumn("isinstance_modifiable", this.stringManager.getString("is-instance-modifable"), 60, (TableCellRenderer)renderer));
        }
        columns.add(new QueryTableColumn("description", this.stringManager.getString("description"), 300, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("update_comment", this.stringManager.getString("update-comment"), 200, (TableCellRenderer)renderer));
        return columns.toArray(new QueryTableColumn[columns.size()]);
    }

    public String getSql(SqlFilter filter) {
        return Sql.getParameterList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("name", this.stringManager.getString("name"), (String[])null), new SqlFilterDefComponent("display_type", this.stringManager.getString("display-param-type"), new String[]{"'BOOLEAN'", "'STRING'", "'INTEGER'", "'PARAMETER FILE'", "'RESERVED'", "'BIG INTEGER'"}), new SqlFilterDefComponent("display_value", this.stringManager.getString("display-param-value"), (String[])null), new SqlFilterDefComponent("ismodified <> 'FALSE'", this.stringManager.getString("are-modified")), new SqlFilterDefComponent("isdeprecated <> 'TRUE'", this.stringManager.getString("are-deprecated"))};
    }

    public String[] getSchemaList() {
        return null;
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("user_text").setString(this.searchPanel.getText());
    }
}

