/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.dfvisual;

import java.awt.Color;
import pl.mpak.orbada.oracle.dba.gui.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameInfo
implements Comparable<NameInfo> {
    public static final Color backgroundColor = Color.LIGHT_GRAY;
    private String name;
    private long blocks;
    private long bytes;
    protected Color color;
    protected Color grayedColor;
    protected Color lightedColor;

    public NameInfo(String name) {
        this.name = name;
        this.setColor(GuiUtil.randomColor());
        this.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getBlocks() {
        return this.blocks;
    }

    public void setBlocks(long blocks) {
        this.blocks = blocks;
    }

    public void addBlocks(long blocks) {
        this.blocks += blocks;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public void addBytes(long bytes) {
        this.bytes += bytes;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getGrayedColor() {
        return this.grayedColor;
    }

    public Color getLightedColor() {
        return this.lightedColor;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.color != null) {
            int r = (backgroundColor.getRed() + this.color.getRed()) / 2;
            int g = (backgroundColor.getGreen() + this.color.getGreen()) / 2;
            int b = (backgroundColor.getBlue() + this.color.getBlue()) / 2;
            this.grayedColor = new Color(r, g, b);
            r = Math.min(this.color.getRed() + 40, 255);
            g = Math.min(this.color.getGreen() + 40, 255);
            b = Math.min(this.color.getBlue() + 40, 255);
            this.lightedColor = new Color(r, g, b);
        }
    }

    public void clear() {
        this.blocks = 0L;
        this.bytes = 0L;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(NameInfo o) {
        return this.name.compareTo(o.getName());
    }
}

