/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.dfvisual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.db.ConnectionFactory;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.SearchOnTable;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.oracle.OrbadaOraclePlugin;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.DataFileInfo;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.ExtentInfo;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.NameInfo;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.OwnerInfo;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.PartitionInfo;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.SegmentInfo;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.SegmentTypeInfo;
import pl.mpak.orbada.oracle.dba.gui.dfvisual.TablespaceInfo;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.util.ButtonTableHeader;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.Order;
import pl.mpak.util.SortableTable;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.TaskUtil;
import pl.mpak.util.task.Task;
import pl.mpak.util.task.TaskExecutor;
import pl.mpak.util.timer.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualDataFilePanelView
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private static Dimension[] displayBlockSizes = new Dimension[]{new Dimension(3, 3), new Dimension(5, 5), new Dimension(8, 8), new Dimension(5, 9)};
    private IViewAccesibilities accesibilities;
    private boolean viewClosing = false;
    private volatile boolean cancelFlag;
    private volatile boolean colecting;
    private Timer timerRefresh;
    private Database database;
    private volatile boolean refreshRequest;
    private volatile boolean painting;
    private JPanel panelBlocks;
    private HashMap<String, TablespaceInfo> tablespaceMap;
    private HashMap<Long, DataFileInfo> dataFileMap;
    private HashMap<String, SegmentInfo> segmentMap;
    private HashMap<String, SegmentTypeInfo> segmentTypeMap;
    private HashMap<String, OwnerInfo> userMap;
    private HashMap<String, PartitionInfo> partitionMap;
    private HashMap<Long, ExtentInfo> extentMap;
    private HashMap<String, SegmentInfo> segmentTempMap;
    private HashMap<String, SegmentTypeInfo> segmentTypeTempMap;
    private HashMap<String, OwnerInfo> userTempMap;
    private HashMap<String, PartitionInfo> partitionTempMap;
    private ArrayList<DataFileInfo> dataFileList;
    private ArrayList<NameInfo> legendList;
    private long selectedFileId = -1L;
    private NameInfo selectedInfo = null;
    private boolean selectedInfoSwitcher;
    private SearchOnTable searchOnTable;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JProgressBar collectProgress;
    private ComboBox comboBlockSize;
    private ComboBox comboGroup;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JToolBar jToolBar1;
    private JLabel labelProgress;
    private JLabel labelRefresh;
    private JPopupMenu menuActions;
    private JPanel panelProgress;
    private JScrollPane scrollBlocks;
    private Table tableDataFiles;
    private Table tableLegend;
    private JToolBar toolBar;

    public VisualDataFilePanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.cloneDatabase();
        this.tablespaceMap = new HashMap();
        this.dataFileMap = new HashMap();
        this.segmentMap = new HashMap();
        this.segmentTypeMap = new HashMap();
        this.userMap = new HashMap();
        this.partitionMap = new HashMap();
        this.extentMap = new HashMap();
        this.dataFileList = new ArrayList();
        this.legendList = new ArrayList();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboGroup.setModel(new DefaultComboBoxModel<String>(new String[]{this.stringManager.getString("segment-name"), this.stringManager.getString("segment-kind"), this.stringManager.getString("owner"), this.stringManager.getString("partition")}));
        this.timerRefresh = new Timer(1000L){

            public void run() {
                if (VisualDataFilePanelView.this.refreshRequest && !VisualDataFilePanelView.this.painting || VisualDataFilePanelView.this.selectedInfo != null) {
                    VisualDataFilePanelView.this.selectedInfoSwitcher = !VisualDataFilePanelView.this.selectedInfoSwitcher;
                    VisualDataFilePanelView.this.panelBlocks.repaint();
                    VisualDataFilePanelView.this.refreshRequest = false;
                }
            }
        };
        OrbadaOraclePlugin.getRefreshQueue().add(this.timerRefresh);
        this.scrollBlocks.setViewportView(this.getPanelBlocks());
        this.scrollBlocks.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                VisualDataFilePanelView.this.refreshRequest = true;
            }
        });
        this.tableDataFiles.setSelectionMode(0);
        this.tableDataFiles.setModel(this.getDataFileTableModel());
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(0, 40, this.stringManager.getString("file-id"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(1, 450, this.stringManager.getString("database-file"), (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(2, 130, this.stringManager.getString("space"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(3, 85, this.stringManager.getString("status"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(4, 85, this.stringManager.getString("connected"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(5, 60, this.stringManager.getString("block-size"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(6, 85, this.stringManager.getString("blocks"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(7, 85, this.stringManager.getString("bytes"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(8, 85, this.stringManager.getString("free-blocks"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(9, 85, this.stringManager.getString("free-bytes"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableDataFiles.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (VisualDataFilePanelView.this.tableDataFiles.getSelectedRow() >= 0 && ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(VisualDataFilePanelView.this.tableDataFiles.getSelectedRow())).getFileId() != VisualDataFilePanelView.this.selectedFileId) {
                    VisualDataFilePanelView.this.resetAndCollect();
                }
            }
        });
        this.tableLegend.setSelectionMode(0);
        this.tableLegend.setModel((TableModel)new LegendTableModel());
        this.tableLegend.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(0, 30, this.stringManager.getString("color"), (TableCellRenderer)new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Color) {
                    this.rendererLabel.setText("");
                    this.rendererLabel.setBackground((Color)value);
                }
                return this.rendererLabel;
            }
        }));
        this.tableLegend.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(1, 150, this.stringManager.getString("name"), (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableLegend.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(2, 90, this.stringManager.getString("blocks"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableLegend.addColumn((TableColumn)new pl.mpak.sky.gui.swing.comp.TableColumn(3, 90, this.stringManager.getString("bytes"), (TableCellRenderer)new QueryTableCellRenderer()));
        this.tableLegend.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (VisualDataFilePanelView.this.tableLegend.getSelectedRow() >= 0) {
                    VisualDataFilePanelView.this.selectedInfo = (NameInfo)VisualDataFilePanelView.this.legendList.get(VisualDataFilePanelView.this.tableLegend.getSelectedRow());
                } else {
                    VisualDataFilePanelView.this.selectedInfo = null;
                }
                VisualDataFilePanelView.this.refreshRequest = true;
            }
        });
        this.tableLegend.setTableHeader((JTableHeader)new ButtonTableHeader(this.tableLegend.getColumnModel()));
        this.searchOnTable = new SearchOnTable((JTable)this.tableLegend);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                VisualDataFilePanelView.this.collectDataFileList();
            }
        });
        this.panelProgress.setVisible(false);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableDataFiles, (JButton)this.buttonActions, this.menuActions, "oracle-visual-datafiles-actions");
    }

    private TableModel getDataFileTableModel() {
        return new AbstractTableModel(){

            public int getRowCount() {
                return VisualDataFilePanelView.this.dataFileList.size();
            }

            public int getColumnCount() {
                return 0;
            }

            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getFileId();
                    }
                    case 1: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getName();
                    }
                    case 2: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getTablespace();
                    }
                    case 3: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getStatus();
                    }
                    case 4: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getOnlineStatus();
                    }
                    case 5: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getBlockSize();
                    }
                    case 6: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getBlocks();
                    }
                    case 7: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getBytes();
                    }
                    case 8: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getFreeBlocks();
                    }
                    case 9: {
                        return ((DataFileInfo)VisualDataFilePanelView.this.dataFileList.get(rowIndex)).getFreeBytes();
                    }
                }
                return null;
            }
        };
    }

    private JPanel getPanelBlocks() {
        if (this.panelBlocks == null) {
            this.panelBlocks = new JPanel(){
                {
                    this.setBackground(NameInfo.backgroundColor);
                    this.setFocusable(true);
                    this.addMouseMotionListener(new MouseMotionListener(){
                        int lastX = -1;
                        int lastY = -1;

                        public void mouseDragged(MouseEvent e) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void mouseMoved(MouseEvent e) {
                            Dimension dbs = VisualDataFilePanelView.this.getDisplayBlockSize();
                            Rectangle rect = VisualDataFilePanelView.this.scrollBlocks.getViewport().getViewRect();
                            int width = rect.width;
                            int columns = width / (dbs.width + 1);
                            int x = Math.min(e.getX() / (dbs.width + 1), columns);
                            int y = e.getY() / (dbs.height + 1);
                            if (this.lastX != x || this.lastY != y) {
                                ExtentInfo onInfo = null;
                                HashMap hashMap = VisualDataFilePanelView.this.extentMap;
                                synchronized (hashMap) {
                                    int blockId = y * columns + x;
                                    for (ExtentInfo info : VisualDataFilePanelView.this.extentMap.values()) {
                                        if ((long)blockId < info.getBlockId() || (long)blockId >= info.getBlockId() + info.getBlocks()) continue;
                                        onInfo = info;
                                        break;
                                    }
                                    if (onInfo != null) {
                                        SegmentInfo segInfo = (SegmentInfo)VisualDataFilePanelView.this.segmentMap.get(onInfo.getSegmentName());
                                        OwnerInfo ownInfo = (OwnerInfo)VisualDataFilePanelView.this.userMap.get(onInfo.getOwnerName());
                                        PartitionInfo partInfo = (PartitionInfo)VisualDataFilePanelView.this.partitionMap.get(onInfo.getPartitionName());
                                        this.setToolTipText(String.format(VisualDataFilePanelView.this.stringManager.getString("VisualDataFilePanelView-block-info"), x, y, y * columns + x, onInfo.getBlocks(), onInfo.getSegmentName(), onInfo.getSegmentType(), segInfo != null ? segInfo.getBlocks() : 0L, onInfo.getOwnerName(), ownInfo != null ? ownInfo.getBlocks() : 0L, onInfo.getPartitionName(), partInfo != null ? partInfo.getBlocks() : 0L));
                                    } else {
                                        this.setToolTipText(null);
                                    }
                                }
                            }
                        }
                    });
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void paintComponent(Graphics g) {
                    VisualDataFilePanelView.this.painting = true;
                    try {
                        super.paintComponent(g);
                        VisualDataFilePanelView.this.paintBlocks(g);
                    }
                    finally {
                        VisualDataFilePanelView.this.painting = false;
                    }
                }
            };
        }
        return this.panelBlocks;
    }

    private void cloneDatabase() {
        ConnectionFactory factory = new ConnectionFactory(this.getDatabase());
        try {
            this.database = factory.createDatabase();
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectDataFileList() {
        HashMap<Long, ExtentInfo> hashMap = this.extentMap;
        synchronized (hashMap) {
            this.dataFileMap.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.open(Sql.getDataFileList());
                while (!query.eof()) {
                    DataFileInfo info = new DataFileInfo(query.fieldByName("file_name").getString(), query.fieldByName("tablespace_name").getString(), query.fieldByName("file_id").getLong(), query.fieldByName("blocks").getLong(), query.fieldByName("bytes").getLong(), query.fieldByName("block_size").getLong(), query.fieldByName("status").getString(), query.fieldByName("online_status").getString(), query.fieldByName("free_blocks").getLong(), query.fieldByName("free_bytes").getLong());
                    this.dataFileMap.put(info.getFileId(), info);
                    query.next();
                }
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int columnIndex = VisualDataFilePanelView.this.tableDataFiles.getSelectedColumn();
                HashMap hashMap = VisualDataFilePanelView.this.extentMap;
                synchronized (hashMap) {
                    VisualDataFilePanelView.this.dataFileList.clear();
                    int lastSelected = -1;
                    int index = 0;
                    for (DataFileInfo info : VisualDataFilePanelView.this.dataFileMap.values()) {
                        if (VisualDataFilePanelView.this.selectedFileId == info.getFileId()) {
                            lastSelected = index;
                        }
                        ++index;
                        VisualDataFilePanelView.this.dataFileList.add(info);
                    }
                    VisualDataFilePanelView.this.tableDataFiles.revalidate();
                    if (lastSelected == -1 && VisualDataFilePanelView.this.dataFileList.size() > 0) {
                        VisualDataFilePanelView.this.tableDataFiles.changeSelection(0, columnIndex, false, false);
                    } else {
                        VisualDataFilePanelView.this.tableDataFiles.changeSelection(lastSelected, columnIndex, false, false);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBlocks(Graphics g) {
        if (this.selectedFileId == -1L) {
            return;
        }
        DataFileInfo fileInfo = this.dataFileMap.get(this.selectedFileId);
        Dimension dbs = this.getDisplayBlockSize();
        Rectangle rect = this.scrollBlocks.getViewport().getViewRect();
        Rectangle clip = g.getClipBounds();
        clip.grow(dbs.width, dbs.height);
        int width = rect.width;
        int columns = width / (dbs.width + 1);
        int groupSelected = this.comboGroup.getSelectedIndex();
        HashMap<Long, ExtentInfo> hashMap = this.extentMap;
        synchronized (hashMap) {
            for (ExtentInfo info : this.extentMap.values()) {
                long y = info.getBlockId() / (long)columns * (long)(dbs.height + 1);
                long yh = (info.getBlockId() + info.getBlocks()) / (long)columns * (long)(dbs.height + 1) + (long)(dbs.height + 1);
                if ((long)clip.y >= Math.min(y, (long)clip.y) && (long)(clip.y + clip.height) <= Math.max(yh, (long)(clip.y + clip.height))) {
                    long x = info.getBlockId() % (long)columns * (long)(dbs.width + 1);
                    Object currInfo = null;
                    Color color = Color.BLACK;
                    Color selectedColor = null;
                    if ("FREE".equals(info.getSegmentType())) {
                        color = Color.WHITE;
                    } else if (groupSelected == 0) {
                        currInfo = this.segmentMap.get(info.getSegmentName());
                    } else if (groupSelected == 1) {
                        currInfo = this.segmentTypeMap.get(info.getSegmentType());
                    } else if (groupSelected == 2) {
                        currInfo = this.userMap.get(info.getOwnerName());
                    } else if (groupSelected == 3) {
                        currInfo = this.partitionMap.get(info.getPartitionName());
                    }
                    if (currInfo != null) {
                        if (currInfo.equals(this.selectedInfo)) {
                            selectedColor = this.selectedInfo.getLightedColor();
                        }
                        color = ((NameInfo)currInfo).getColor();
                    }
                    if (selectedColor != null && this.selectedInfoSwitcher) {
                        g.setColor(selectedColor);
                    } else {
                        g.setColor(color);
                    }
                    int ic = 0;
                    while ((long)ic < info.getBlocks()) {
                        if (x + (long)dbs.width > (long)width) {
                            x = 0L;
                            y += (long)(dbs.height + 1);
                        }
                        if (clip.contains((int)x, (int)y, dbs.width, dbs.height)) {
                            g.fillRect((int)x, (int)y, dbs.width, dbs.height);
                        }
                        x += (long)(dbs.width + 1);
                        ++ic;
                    }
                }
                if (!this.cancelFlag) continue;
                break;
            }
        }
    }

    private void updateDisplayPanelSize() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (VisualDataFilePanelView.this.selectedFileId == -1L) {
                    return;
                }
                DataFileInfo fileInfo = (DataFileInfo)VisualDataFilePanelView.this.dataFileMap.get(VisualDataFilePanelView.this.selectedFileId);
                Dimension dbs = VisualDataFilePanelView.this.getDisplayBlockSize();
                int width = ((VisualDataFilePanelView)VisualDataFilePanelView.this).scrollBlocks.getViewport().getViewRect().width;
                int columns = width / (dbs.width + 1);
                if (fileInfo != null) {
                    VisualDataFilePanelView.this.panelBlocks.setPreferredSize(new Dimension(width, (int)((Math.floor(fileInfo.getBlocks() / (long)columns) + 1.0) * (double)(dbs.height + 1))));
                }
                VisualDataFilePanelView.this.panelBlocks.revalidate();
                VisualDataFilePanelView.this.scrollBlocks.revalidate();
                VisualDataFilePanelView.this.scrollBlocks.getVerticalScrollBar().setUnitIncrement(dbs.height * 10);
                VisualDataFilePanelView.this.refreshRequest = true;
            }
        });
    }

    private void refreshTask() {
        if (!SwingUtil.isVisible((Component)this) || this.viewClosing || this.colecting) {
            return;
        }
        this.getDatabase().getTaskPool().addTask(new Task("Zbieranie informacji o pliku bazy danych..."){

            public void run() {
                VisualDataFilePanelView.this.refresh();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareInfo() {
        HashMap<Long, ExtentInfo> hashMap = this.extentMap;
        synchronized (hashMap) {
            Iterator<ExtentInfo> i = this.extentMap.values().iterator();
            while (i.hasNext()) {
                i.next().setToRemove();
            }
            this.segmentTempMap = this.segmentTempMap != null ? new HashMap<String, SegmentInfo>() : this.segmentMap;
            this.segmentTypeTempMap = this.segmentTypeTempMap != null ? new HashMap<String, SegmentTypeInfo>() : this.segmentTypeMap;
            this.userTempMap = this.userTempMap != null ? new HashMap<String, OwnerInfo>() : this.userMap;
            this.partitionTempMap = this.partitionTempMap != null ? new HashMap<String, PartitionInfo>() : this.partitionMap;
            this.tablespaceMap.clear();
            this.dataFileMap.clear();
            Query query = this.getDatabase().createQuery();
            try {
                query.open("select tablespace_name, block_size, status from dba_tablespaces");
                while (!query.eof()) {
                    TablespaceInfo info = new TablespaceInfo(query.fieldByName("tablespace_name").getString(), query.fieldByName("block_size").getLong(), query.fieldByName("status").getString());
                    this.tablespaceMap.put(info.getName(), info);
                    query.next();
                }
                this.collectDataFileList();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
            this.updateDisplayPanelSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectInfo() {
        Query query;
        block17: {
            block18: {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        VisualDataFilePanelView.this.labelProgress.setText("...");
                        VisualDataFilePanelView.this.collectProgress.setValue(0);
                        VisualDataFilePanelView.this.panelProgress.setVisible(true);
                    }
                });
                query = this.getDatabase().createQuery();
                try {
                    int percentage;
                    ExtentInfo info;
                    int cnt;
                    long blocks;
                    DataFileInfo dataFileInfo;
                    ArrayList<ExtentInfo> list;
                    block19: {
                        block16: {
                            list = new ArrayList<ExtentInfo>();
                            query.setSqlText("select tablespace_name, owner, segment_name, partition_name, segment_type, file_id, block_id, blocks from dba_extents where file_id = :FILE_ID");
                            query.paramByName("FILE_ID").setLong(this.selectedFileId);
                            query.open();
                            dataFileInfo = this.dataFileMap.get(this.selectedFileId);
                            blocks = 0L;
                            cnt = 0;
                            while (!query.eof()) {
                                info = new ExtentInfo(query.fieldByName("tablespace_name").getString(), query.fieldByName("owner").getString(), query.fieldByName("segment_name").getString(), query.fieldByName("segment_type").getString(), query.fieldByName("partition_name").getValue().toString(), query.fieldByName("file_id").getLong(), query.fieldByName("block_id").getLong(), query.fieldByName("blocks").getLong());
                                blocks += query.fieldByName("blocks").getLong();
                                this.updateMaps(info, dataFileInfo);
                                list.add(info);
                                if (++cnt % 200 == 0) {
                                    Task task;
                                    percentage = (int)((double)blocks / (double)dataFileInfo.getBlocks() * 100.0);
                                    this.updateExtentMap(list);
                                    list = new ArrayList();
                                    if (Thread.currentThread() instanceof TaskExecutor && (task = ((TaskExecutor)Thread.currentThread()).getCurrentTask()) != null) {
                                        task.setPercenExecution(percentage);
                                        if (task.isCanceled()) {
                                            this.cancelFlag = true;
                                        }
                                    }
                                    EventQueue.invokeLater(new Runnable(){

                                        public void run() {
                                            VisualDataFilePanelView.this.collectProgress.setValue(percentage);
                                            VisualDataFilePanelView.this.labelProgress.setText(percentage + "%");
                                        }
                                    });
                                }
                                if (!this.cancelFlag) {
                                    query.next();
                                    continue;
                                }
                                break block16;
                            }
                            query.setSqlText("select tablespace_name, file_id, block_id, blocks from dba_free_space where file_id = :FILE_ID");
                            query.paramByName("FILE_ID").setLong(this.selectedFileId);
                            query.open();
                            cnt = 0;
                            break block19;
                        }
                        query.close();
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                VisualDataFilePanelView.this.panelProgress.setVisible(false);
                            }
                        });
                        return;
                    }
                    while (!query.eof()) {
                        info = new ExtentInfo(query.fieldByName("tablespace_name").getString(), "", "", "FREE", "", query.fieldByName("file_id").getLong(), query.fieldByName("block_id").getLong(), query.fieldByName("blocks").getLong());
                        blocks += query.fieldByName("blocks").getLong();
                        list.add(info);
                        if (++cnt % 200 == 0) {
                            Task task;
                            percentage = (int)((double)blocks / (double)dataFileInfo.getBlocks() * 100.0);
                            this.updateExtentMap(list);
                            list = new ArrayList();
                            if (Thread.currentThread() instanceof TaskExecutor && (task = ((TaskExecutor)Thread.currentThread()).getCurrentTask()) != null) {
                                task.setPercenExecution(percentage);
                                if (task.isCanceled()) {
                                    this.cancelFlag = true;
                                }
                            }
                            final double blocksProgress = blocks;
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    VisualDataFilePanelView.this.collectProgress.setValue((int)(blocksProgress / (double)dataFileInfo.getBlocks() * 100.0));
                                    VisualDataFilePanelView.this.labelProgress.setText(percentage + "%");
                                }
                            });
                        }
                        if (!this.cancelFlag) {
                            query.next();
                            continue;
                        }
                        break block17;
                    }
                    if (list.size() <= 0) break block18;
                    this.updateExtentMap(list);
                }
                catch (Exception ex) {
                    try {
                        ExceptionUtil.processException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        query.close();
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    query.close();
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
            }
            query.close();
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        query.close();
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void updateExtentMap(final ArrayList<ExtentInfo> list) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashMap hashMap = VisualDataFilePanelView.this.extentMap;
                synchronized (hashMap) {
                    for (ExtentInfo info : list) {
                        VisualDataFilePanelView.this.extentMap.put(info.getBlockId(), info);
                    }
                }
                VisualDataFilePanelView.this.updateLegend();
                VisualDataFilePanelView.this.refreshRequest = true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaps(ExtentInfo info, DataFileInfo dfi) {
        HashMap<Long, ExtentInfo> hashMap = this.extentMap;
        synchronized (hashMap) {
            NameInfo pi;
            if (!"".equals(info.getSegmentName())) {
                SegmentInfo si = this.segmentTempMap.get(info.getSegmentName());
                if (si == null) {
                    si = new SegmentInfo(info.getSegmentName());
                    this.segmentTempMap.put(si.getName(), si);
                    if (this.segmentMap.get(si.getName()) != null) {
                        si.setColor(this.segmentMap.get(si.getName()).getColor());
                    }
                }
                info.updateInfo(si, dfi.getBlockSize());
            }
            if (!"".equals(info.getSegmentType())) {
                SegmentTypeInfo sti = this.segmentTypeTempMap.get(info.getSegmentType());
                if (sti == null) {
                    sti = new SegmentTypeInfo(info.getSegmentType());
                    this.segmentTypeTempMap.put(sti.getName(), sti);
                    if (this.segmentTypeMap.get(sti.getName()) != null) {
                        sti.setColor(this.segmentTypeMap.get(sti.getName()).getColor());
                    }
                }
                info.updateInfo(sti, dfi.getBlockSize());
            }
            if (!"".equals(info.getOwnerName())) {
                OwnerInfo oi = this.userTempMap.get(info.getOwnerName());
                if (oi == null) {
                    oi = new OwnerInfo(info.getOwnerName());
                    this.userTempMap.put(oi.getName(), oi);
                    if (this.userMap.get(oi.getName()) != null) {
                        oi.setColor(this.userMap.get(oi.getName()).getColor());
                    }
                }
                info.updateInfo(oi, dfi.getBlockSize());
            }
            if (!"".equals(info.getPartitionName())) {
                pi = this.partitionTempMap.get(info.getPartitionName());
                if (pi == null) {
                    pi = new PartitionInfo(info.getPartitionName());
                    this.partitionTempMap.put(pi.getName(), (PartitionInfo)pi);
                    if (this.partitionMap.get(pi.getName()) != null) {
                        pi.setColor(this.partitionMap.get(pi.getName()).getColor());
                    }
                }
                info.updateInfo(pi, dfi.getBlockSize());
            }
            if (!"".equals(info.getTablespaceName())) {
                pi = this.tablespaceMap.get(info.getTablespaceName());
                info.updateInfo(pi, dfi.getBlockSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneInfo() {
        HashMap<Long, ExtentInfo> hashMap = this.extentMap;
        synchronized (hashMap) {
            Iterator<ExtentInfo> i = this.extentMap.values().iterator();
            while (i.hasNext()) {
                ExtentInfo info = i.next();
                if (!info.isToRemove()) continue;
                i.remove();
            }
            this.segmentMap = this.segmentTempMap;
            this.segmentTypeMap = this.segmentTypeTempMap;
            this.userMap = this.userTempMap;
            this.partitionMap = this.partitionTempMap;
            this.refreshRequest = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        if (!SwingUtil.isVisible((Component)this) || this.viewClosing || this.colecting) {
            return;
        }
        this.cancelFlag = false;
        this.setColecting(true);
        try {
            this.prepareInfo();
            this.collectInfo();
            this.doneInfo();
        }
        finally {
            this.setColecting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLegend() {
        int index = -1;
        HashMap<Long, ExtentInfo> hashMap = this.extentMap;
        synchronized (hashMap) {
            int i = 0;
            this.legendList.clear();
            if (this.comboGroup.getSelectedIndex() == 0) {
                for (SegmentInfo info : this.segmentMap.values()) {
                    if (this.selectedInfo != null && info.getName().equals(this.selectedInfo.getName())) {
                        index = i;
                    }
                    ++i;
                    this.legendList.add(info);
                }
            } else if (this.comboGroup.getSelectedIndex() == 1) {
                for (SegmentTypeInfo info : this.segmentTypeMap.values()) {
                    if (this.selectedInfo != null && info.getName().equals(this.selectedInfo.getName())) {
                        index = i;
                    }
                    ++i;
                    this.legendList.add(info);
                }
            } else if (this.comboGroup.getSelectedIndex() == 2) {
                for (OwnerInfo info : this.userMap.values()) {
                    if (this.selectedInfo != null && info.getName().equals(this.selectedInfo.getName())) {
                        index = i;
                    }
                    ++i;
                    this.legendList.add(info);
                }
            } else if (this.comboGroup.getSelectedIndex() == 3) {
                for (PartitionInfo info : this.partitionMap.values()) {
                    if (this.selectedInfo != null && info.getName().equals(this.selectedInfo.getName())) {
                        index = i;
                    }
                    ++i;
                    this.legendList.add(info);
                }
            }
        }
        final int selectedIndex = index;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                VisualDataFilePanelView.this.tableLegend.revalidate();
                VisualDataFilePanelView.this.tableLegend.repaint();
                VisualDataFilePanelView.this.tableLegend.changeSelection(selectedIndex, 1, false, false);
                ((LegendTableModel)VisualDataFilePanelView.this.tableLegend.getModel()).sortByColumn(1, Order.ASCENDING, 0);
            }
        });
    }

    public void setColecting(boolean colecting) {
        this.colecting = colecting;
        this.cmRefresh.setEnabled(!colecting);
        this.labelRefresh.setEnabled(colecting);
    }

    public Database getDatabase() {
        return this.database == null ? this.accesibilities.getDatabase() : this.database;
    }

    private Dimension getDisplayBlockSize() {
        return displayBlockSizes[this.comboBlockSize.getSelectedIndex()];
    }

    @Override
    public void close() throws IOException {
        this.viewClosing = true;
        this.cancel();
        this.searchOnTable.done();
        this.timerRefresh.cancel();
        if (this.database != null) {
            this.database.close();
        }
        this.accesibilities = null;
    }

    private void cancel() {
        this.cancelFlag = true;
        while (this.colecting || this.painting) {
            TaskUtil.sleep((long)10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAndCollect() {
        this.cancel();
        HashMap<Long, ExtentInfo> hashMap = this.extentMap;
        synchronized (hashMap) {
            this.extentMap.clear();
            this.segmentTempMap = null;
            this.segmentTypeTempMap = null;
            this.userTempMap = null;
            this.partitionTempMap = null;
            this.segmentMap.clear();
            this.segmentTypeMap.clear();
            this.userMap.clear();
            this.partitionMap.clear();
        }
        this.updateLegend();
        if (this.tableDataFiles.getSelectedRow() >= 0) {
            this.selectedFileId = this.dataFileList.get(this.tableDataFiles.getSelectedRow()).getFileId();
        }
        this.refreshTask();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.tableDataFiles = new Table();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.comboGroup = new ComboBox();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableLegend = new Table();
        this.jPanel4 = new JPanel();
        this.scrollBlocks = new JScrollPane();
        this.jPanel6 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.jPanel5 = new JPanel();
        this.jLabel3 = new JLabel();
        this.comboBlockSize = new ComboBox();
        this.panelProgress = new JPanel();
        this.collectProgress = new JProgressBar();
        this.labelProgress = new JLabel();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.labelRefresh = new JLabel();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisualDataFilePanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                VisualDataFilePanelView.this.formComponentResized(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerLocation(100);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setContinuousLayout(true);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.tableDataFiles.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView((Component)this.tableDataFiles);
        this.jSplitPane2.setLeftComponent(this.jScrollPane2);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setContinuousLayout(true);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel3.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("Button.shadow")));
        this.jPanel3.setPreferredSize(new Dimension(150, 0));
        this.jLabel4.setText(this.stringManager.getString("show-by-dd"));
        this.comboGroup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                VisualDataFilePanelView.this.comboGroupItemStateChanged(evt);
            }
        });
        this.jLabel5.setText(this.stringManager.getString("legend-dd"));
        this.tableLegend.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.tableLegend);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel4, -1, 231, Short.MAX_VALUE).addGap(9, 9, 9)).addGroup(jPanel3Layout.createSequentialGroup().addComponent((Component)this.comboGroup, -1, 230, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 230, Short.MAX_VALUE).addComponent(this.jLabel5, -1, 230, Short.MAX_VALUE)).addContainerGap()))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboGroup, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 194, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel3);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.add((Component)this.scrollBlocks, "Center");
        this.jPanel6.setLayout(new FlowLayout(0, 0, 0));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jPanel5.setLayout(new FlowLayout(0, 1, 1));
        this.jLabel3.setText(this.stringManager.getString("mark-size-dd"));
        this.jPanel5.add(this.jLabel3);
        this.comboBlockSize.setModel(new DefaultComboBoxModel<String>(new String[]{"3x3", "5x5", "8x8", "5x9"}));
        this.comboBlockSize.setSelectedIndex(1);
        this.comboBlockSize.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                VisualDataFilePanelView.this.comboBlockSizeItemStateChanged(evt);
            }
        });
        this.jPanel5.add((Component)this.comboBlockSize);
        this.jToolBar1.add(this.jPanel5);
        this.panelProgress.add(this.collectProgress);
        this.labelProgress.setText("jLabel1");
        this.panelProgress.add(this.labelProgress);
        this.jToolBar1.add(this.panelProgress);
        this.jPanel6.add(this.jToolBar1);
        this.jPanel4.add((Component)this.jPanel6, "North");
        this.jSplitPane1.setRightComponent(this.jPanel4);
        this.jSplitPane2.setRightComponent(this.jSplitPane1);
        this.jPanel1.add((Component)this.jSplitPane2, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.labelRefresh.setIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/orange_bdot.gif"));
        this.labelRefresh.setEnabled(false);
        this.toolBar.add(this.labelRefresh);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.toolBar.add(this.jSeparator2);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refreshTask();
    }

    private void comboBlockSizeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateDisplayPanelSize();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.updateDisplayPanelSize();
    }

    private void comboGroupItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateLegend();
            this.refreshRequest = true;
        }
    }

    private class LegendTableModel
    extends AbstractTableModel
    implements SortableTable {
        private LegendTableModel() {
        }

        public int getRowCount() {
            return VisualDataFilePanelView.this.legendList.size();
        }

        public int getColumnCount() {
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= VisualDataFilePanelView.this.legendList.size()) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((NameInfo)VisualDataFilePanelView.this.legendList.get(rowIndex)).getColor();
                }
                case 1: {
                    return ((NameInfo)VisualDataFilePanelView.this.legendList.get(rowIndex)).getName();
                }
                case 2: {
                    return ((NameInfo)VisualDataFilePanelView.this.legendList.get(rowIndex)).getBlocks();
                }
                case 3: {
                    return ((NameInfo)VisualDataFilePanelView.this.legendList.get(rowIndex)).getBytes();
                }
            }
            return null;
        }

        public void sortByColumn(final int column, final Order order, int modifiers) {
            int columnIndex = VisualDataFilePanelView.this.tableLegend.getSelectedColumn();
            Collections.sort(VisualDataFilePanelView.this.legendList, new Comparator<NameInfo>(){

                @Override
                public int compare(NameInfo o1, NameInfo o2) {
                    switch (column) {
                        case 0: {
                            return order != Order.ASCENDING ? (int)Math.signum(o2.getColor().getRGB() - o1.getColor().getRGB()) : (int)Math.signum(o1.getColor().getRGB() - o2.getColor().getRGB());
                        }
                        case 1: {
                            return order != Order.ASCENDING ? o2.getName().compareTo(o1.getName()) : o1.getName().compareTo(o2.getName());
                        }
                        case 2: {
                            return order != Order.ASCENDING ? (int)Math.signum(o2.getBlocks() - o1.getBlocks()) : (int)Math.signum(o1.getBlocks() - o2.getBlocks());
                        }
                        case 3: {
                            return order != Order.ASCENDING ? (int)Math.signum(o1.getBytes() - o1.getBytes()) : (int)Math.signum(o1.getBytes() - o2.getBytes());
                        }
                    }
                    return 0;
                }
            });
            VisualDataFilePanelView.this.tableLegend.changeSelection(-1, columnIndex, false, false);
        }
    }
}

