/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.sessions;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.comp.RefreshEvent;
import pl.mpak.sky.gui.swing.comp.RefreshListener;
import pl.mpak.sky.gui.swing.comp.RefreshPanel;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class LocksPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private boolean clusters;
    private RefreshPanel refreshPanel;

    public LocksPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.clusters = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("rac-detect", "false"));
        this.refreshPanel = new RefreshPanel();
        this.refreshPanel.addRefreshListener(new RefreshListener(){

            public void refresh(RefreshEvent e) {
                LocksPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.refreshPanel);
        super.init();
    }

    public Component getTabbedPane() {
        return null;
    }

    public String getCurrentSchemaName() {
        return null;
    }

    public String getPanelName() {
        return "oracle-session-locks";
    }

    public String getSchemaColumnName() {
        return null;
    }

    public String getObjectColumnName() {
        return "sid";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        ArrayList<QueryTableColumn> columns = new ArrayList<QueryTableColumn>();
        QueryTableCellRenderer renderer = new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    try {
                        if (!"ACTIVE".equals(LocksPanelView.this.getQuery().fieldByName("lockwait").getString())) {
                            label.setBackground(new Color(251, 121, 121));
                        } else if (LocksPanelView.this.getQuery().fieldByName("sid").getString().equals(LocksPanelView.this.getDatabase().getUserProperties().getProperty("sid"))) {
                            label.setBackground(new Color(180, 205, 240));
                        }
                    }
                    catch (Exception ex) {
                        label.setText(label.getText() + " [" + ex.getMessage() + "]");
                    }
                }
                return label;
            }
        };
        if (this.clusters) {
            columns.add(new QueryTableColumn("inst_id", this.stringManager.getString("instance"), 30, (TableCellRenderer)renderer));
        }
        columns.add(new QueryTableColumn("serial#", this.stringManager.getString("serial-hash"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("sid", this.stringManager.getString("sid"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("audsid", this.stringManager.getString("audsid"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("oracle_username", this.stringManager.getString("oracle-user-name"), 100, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("os_username", this.stringManager.getString("os-user-name"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("machine", this.stringManager.getString("machine"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("program", this.stringManager.getString("user-program"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 100, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("object", this.stringManager.getString("objects"), 150, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("lockwait", this.stringManager.getString("lock-wait"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("locked_mode", this.stringManager.getString("locked-mode"), 120, (TableCellRenderer)renderer));
        return columns.toArray(new QueryTableColumn[columns.size()]);
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionLockList(filter.getSqlText(), this.clusters);
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("l.oracle_username", this.stringManager.getString("oracle-user-name"), (String[])null), new SqlFilterDefComponent("o.owner", this.stringManager.getString("object-schema"), (String[])null), new SqlFilterDefComponent("locked_mode", this.stringManager.getString("only-lock-sessions"), new String[]{"None", "Null", "Row-Shared", "Row-Exclusive", "Share", "Share Row-Exclusive", "Exclusive"})};
    }

    public String[] getSchemaList() {
        return null;
    }
}

