/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.sessions;

import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SessionLocksTabPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private boolean clusters;

    public SessionLocksTabPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.clusters = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("rac-detect", "false"));
        super.init();
    }

    public String getTitle() {
        return this.stringManager.getString("SessionLocksTabPanel-title");
    }

    public String getPanelName() {
        return "oracle-session-locks";
    }

    public String getSchemaColumnName() {
        if (this.clusters) {
            return "inst_id";
        }
        return null;
    }

    public String getObjectColumnName() {
        return "sid";
    }

    public String getPropColumnName() {
        return "object";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("object_type", this.stringManager.getString("obejct-type"), 150), new QueryTableColumn("object", this.stringManager.getString("object"), 200), new QueryTableColumn("lockwait", this.stringManager.getString("lock-wait"), 150), new QueryTableColumn("locked_mode", this.stringManager.getString("locked-mode"), 150)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionLockList(filter.getSqlText(), this.clusters);
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("o.object_type", this.stringManager.getString("object-type"), (String[])null), new SqlFilterDefComponent("o.owner||'.'||o.object_name", this.stringManager.getString("object"), (String[])null), new SqlFilterDefComponent("nvl( s.lockwait, 'ACTIVE' )", this.stringManager.getString("lock-wait"), (String[])null)};
    }

    public void afterOpen(Query query) {
        this.requestRefresh = true;
    }
}

