/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.sessions;

import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SessionSqlsTabPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private boolean clusters;

    public SessionSqlsTabPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.clusters = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("rac-detect", "false"));
        super.init();
    }

    public String getTitle() {
        return this.stringManager.getString("SessionSqlsTabPanel-title");
    }

    public String getPanelName() {
        return "oracle-session-sqls";
    }

    public String getSchemaColumnName() {
        if (this.clusters) {
            return "inst_id";
        }
        return null;
    }

    public String getObjectColumnName() {
        return "sid";
    }

    public String getPropColumnName() {
        return "address";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("last_active_time", this.stringManager.getString("last-active-time"), 120), new QueryTableColumn("sharable_mem", this.stringManager.getString("sharable-mem"), 100), new QueryTableColumn("persistent_mem", this.stringManager.getString("persistent-mem"), 100), new QueryTableColumn("runtime_mem", this.stringManager.getString("runtime-mem"), 100), new QueryTableColumn("executions", this.stringManager.getString("executions"), 70), new QueryTableColumn("disk_reads", this.stringManager.getString("disk-reads"), 70), new QueryTableColumn("buffer_gets", this.stringManager.getString("buffer-gets"), 70), new QueryTableColumn("cpu_time", this.stringManager.getString("cpu-time"), 70), new QueryTableColumn("elapsed_time", this.stringManager.getString("elapsed-time"), 70), new QueryTableColumn("optimizer_mode", this.stringManager.getString("optimizer-mode"), 130), new QueryTableColumn("sql_text", this.stringManager.getString("sql-text"), 600)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionSqlList(filter.getSqlText(), this.clusters);
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("s.optimizer_mode", this.stringManager.getString("optimizer-mode"), new String[]{"'ALL_ROWS'", "'FIRST_ROWS'", "'CHOOSE'"}), new SqlFilterDefComponent("(s.sharable_mem +s.persistent_mem +s.runtime_mem)", this.stringManager.getString("total-mem"), (String[])null), new SqlFilterDefComponent("s.executions", this.stringManager.getString("executions"), (String[])null), new SqlFilterDefComponent("s.disk_reads", this.stringManager.getString("disk-reads"), (String[])null), new SqlFilterDefComponent("s.buffer_gets", this.stringManager.getString("buffer-gets"), (String[])null)};
    }

    public void afterOpen(Query query) {
        this.requestRefresh = true;
    }
}

