/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.sessions;

import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SessionStatsTabPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private boolean clusters;

    public SessionStatsTabPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.clusters = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("rac-detect", "false"));
        super.init();
    }

    public String getTitle() {
        return this.stringManager.getString("SessionStatsTabPanel-title");
    }

    public String getPanelName() {
        return "oracle-session-stats";
    }

    public String getSchemaColumnName() {
        if (this.clusters) {
            return "inst_id";
        }
        return null;
    }

    public String getObjectColumnName() {
        return "sid";
    }

    public String getPropColumnName() {
        return "statistic#";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("name", this.stringManager.getString("name"), 300), new QueryTableColumn("value", this.stringManager.getString("value"), 200)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionStatList(filter.getSqlText(), this.clusters);
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("n.name", this.stringManager.getString("name"), (String[])null), new SqlFilterDefComponent("s.value", this.stringManager.getString("value"), (String[])null)};
    }

    public void afterOpen(Query query) {
        this.requestRefresh = true;
    }
}

