/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.sessions;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.oracle.dba.gui.sessions.SessionTabbedPane;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.comp.RefreshEvent;
import pl.mpak.sky.gui.swing.comp.RefreshListener;
import pl.mpak.sky.gui.swing.comp.RefreshPanel;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SessionsPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private boolean clusters;
    private boolean dbaRole;
    private boolean lockRole;
    private boolean sqlRole;
    private RefreshPanel refreshPanel;

    public SessionsPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.clusters = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("rac-detect", "false"));
        this.dbaRole = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("dba-role", "false"));
        this.lockRole = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("lock-view-role", "false"));
        this.sqlRole = StringUtil.toBoolean((String)this.getDatabase().getUserProperties().getProperty("sql-view-role", "false"));
        this.refreshPanel = new RefreshPanel();
        this.refreshPanel.addRefreshListener(new RefreshListener(){

            public void refresh(RefreshEvent e) {
                SessionsPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.refreshPanel);
        super.init();
    }

    public Component getTabbedPane() {
        if (this.dbaRole || this.lockRole || this.sqlRole) {
            return new SessionTabbedPane(this.accesibilities);
        }
        return null;
    }

    public String getCurrentSchemaName() {
        return null;
    }

    protected void refreshTabbedPanes() {
        try {
            if (this.clusters && !this.getQuery().isEmpty()) {
                int rowIndex = this.getTable().getSelectedRow();
                if (rowIndex >= 0) {
                    this.getQuery().getRecord(rowIndex);
                    this.currentSchemaName = this.getQuery().fieldByName("inst_id").getString();
                }
            } else {
                this.currentSchemaName = "";
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        super.refreshTabbedPanes();
    }

    public String getPanelName() {
        return "oracle-sessions";
    }

    public String getSchemaColumnName() {
        return null;
    }

    public String getObjectColumnName() {
        return "sid";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        ArrayList<QueryTableColumn> columns = new ArrayList<QueryTableColumn>();
        QueryTableCellRenderer renderer = new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    try {
                        if (!SessionsPanelView.this.getQuery().fieldByName("lockwait").isNull()) {
                            label.setBackground(new Color(251, 121, 121));
                        } else if (SessionsPanelView.this.getQuery().fieldByName("sid").getString().equals(SessionsPanelView.this.getDatabase().getUserProperties().getProperty("sid"))) {
                            label.setBackground(new Color(180, 205, 240));
                        } else if (value != null && value.toString().equals("INACTIVE")) {
                            label.setForeground(Color.GRAY);
                        }
                    }
                    catch (Exception ex) {
                        label.setText(label.getText() + " [" + ex.getMessage() + "]");
                    }
                }
                return label;
            }
        };
        if (this.clusters) {
            columns.add(new QueryTableColumn("inst_id", this.stringManager.getString("instance"), 30, (TableCellRenderer)renderer));
        }
        columns.add(new QueryTableColumn("sid", this.stringManager.getString("sid"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("spid", this.stringManager.getString("spid"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("process", this.stringManager.getString("process"), 60, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("pid", this.stringManager.getString("pid"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("serial#", this.stringManager.getString("serial-hash"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("audsid", this.stringManager.getString("audsid"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("status", this.stringManager.getString("status"), 60, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("command", this.stringManager.getString("command"), 70, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("wait_sec", this.stringManager.getString("wait-sec"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("type", this.stringManager.getString("type"), 80, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("username", this.stringManager.getString("oracle-user-name"), 100, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("osuser", this.stringManager.getString("os-user-name"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("machine", this.stringManager.getString("machine"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("program", this.stringManager.getString("user-program"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("osprogram", this.stringManager.getString("oracle-process"), 130, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("module", this.stringManager.getString("application-module"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("action", this.stringManager.getString("application-action"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("client_info", this.stringManager.getString("application-client-info"), 150, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("logon_time", this.stringManager.getString("login-time"), 120, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("lockwait", this.stringManager.getString("lock-wait"), 90, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("blocking_session", this.stringManager.getString("blocking-session"), 70, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("physical_reads", this.stringManager.getString("physical-reads"), 90, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("block_gets", this.stringManager.getString("block-gets"), 90, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("consistent_gets", this.stringManager.getString("consistent-gets"), 90, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("block_changes", this.stringManager.getString("block-changes"), 90, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("consistent_changes", this.stringManager.getString("consistent-changes"), 90, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("event", this.stringManager.getString("event"), 150, (TableCellRenderer)renderer));
        return columns.toArray(new QueryTableColumn[columns.size()]);
    }

    public String getSql(SqlFilter filter) {
        return Sql.getSessionList(filter.getSqlText(), this.clusters);
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("s.USERNAME is not null and s.type <> 'BACKGROUND'", this.stringManager.getString("only-user-sessions")), new SqlFilterDefComponent("s.USERNAME", this.stringManager.getString("oracle-user-name"), (String[])null), new SqlFilterDefComponent("s.osuser", this.stringManager.getString("os-user-name"), (String[])null), new SqlFilterDefComponent("s.machine", this.stringManager.getString("machine"), (String[])null), new SqlFilterDefComponent("s.module", this.stringManager.getString("application-module"), (String[])null), new SqlFilterDefComponent("s.action", this.stringManager.getString("application-action"), (String[])null), new SqlFilterDefComponent("s.client_info", this.stringManager.getString("application-client-info"), (String[])null), new SqlFilterDefComponent("p.program", this.stringManager.getString("user-program"), (String[])null), new SqlFilterDefComponent("lockwait is not null", this.stringManager.getString("only-lock-sessions"))};
    }

    public String[] getSchemaList() {
        return null;
    }

    public boolean isHorizontal() {
        return false;
    }
}

