/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class AlterSetParameterWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private Database database;
    private String paramName;
    private Integer inst_id;
    private int paramType;
    private boolean instanceModifiable;
    private ComboBox comboInstances;
    private ComboBox comboParams;
    private ComboBox comboValue;
    private TextField editComment;
    private ButtonGroup groupScope;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel labelInstances;
    private JLabel labelInstances1;
    private JLabel labelInstances2;
    private JRadioButton radioBoth;
    private JRadioButton radioMemory;
    private JRadioButton radioSpfile;

    public AlterSetParameterWizard(Database database, Integer inst_id, String paramName) {
        this.database = database;
        this.paramName = paramName;
        this.inst_id = inst_id;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardShow() {
        Query query = this.database.createQuery();
        try {
            query.open("select distinct name from gv$parameter order by name");
            this.comboParams.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            this.comboParams.setSelectedItem((Object)this.paramName);
            if (StringUtil.toBoolean((String)this.database.getUserProperties().getProperty("Ora10+"))) {
                query.setSqlText("select value from gv$parameter_valid_values where inst_id = :inst_id and name = :name order by ordinal");
                query.paramByName("inst_id").setInteger(this.inst_id.intValue());
                query.paramByName("name").setString(this.paramName);
                query.open();
                if (!query.eof()) {
                    this.comboValue.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
                }
            }
            query.setSqlText("select value, type, isinstance_modifiable from gv$parameter where inst_id = :inst_id and name = :name");
            query.paramByName("inst_id").setInteger(this.inst_id.intValue());
            query.paramByName("name").setString(this.paramName);
            query.open();
            this.paramType = query.fieldByName("type").getInteger();
            this.instanceModifiable = StringUtil.toBoolean((String)query.fieldByName("isinstance_modifiable").getString());
            if (query.fieldByName("type").getInteger() == 1) {
                this.comboValue.setModel(new DefaultComboBoxModel<Object>(new Object[]{"TRUE", "FALSE"}));
            }
            if (!StringUtil.toBoolean((String)this.database.getUserProperties().getProperty("rac-detect", "false")) || !this.instanceModifiable) {
                this.comboInstances.setEnabled(false);
                this.labelInstances.setEnabled(false);
            }
            this.comboValue.setText(query.fieldByName("value").getString());
            query.open("select instance_name name from gv$instance union all select '*' name from dual order by name");
            this.comboInstances.setModel(new DefaultComboBoxModel<String>(QueryUtil.queryToArray((Query)query)));
            this.comboInstances.setText("*");
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    public String getDialogTitle() {
        return this.stringManager.getString("AlterSetParameterWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("AlterSetParameterWizard-tab-title");
    }

    public String getSqlCode() {
        String paramValue = this.comboValue.getText().trim();
        if (!(this.paramType != 2 && this.paramType != 4 || paramValue.length() != 0 && paramValue.charAt(0) == '\'')) {
            paramValue = "'" + paramValue + "'";
        }
        this.getResultMap().put("object_name", this.comboParams.getText());
        return "ALTER SYSTEM SET " + this.comboParams.getSelectedItem().toString() + " = " + paramValue + (!"".equals(this.editComment.getText()) ? "\n  COMMENT = '" + this.editComment.getText() + "'" : "") + "\n  SCOPE = " + (this.radioBoth.isSelected() ? "BOTH" : (this.radioMemory.isSelected() ? "MEMORY" : "SPFILE")) + (this.comboInstances.isEnabled() ? "\n  SID = '" + this.comboInstances.getText() + "'" : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.groupScope = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.comboParams = new ComboBox();
        this.comboValue = new ComboBox();
        this.labelInstances = new JLabel();
        this.comboInstances = new ComboBox();
        this.labelInstances1 = new JLabel();
        this.editComment = new TextField();
        this.radioMemory = new JRadioButton();
        this.radioSpfile = new JRadioButton();
        this.radioBoth = new JRadioButton();
        this.labelInstances2 = new JLabel();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("parameter-name-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("values-dd"));
        this.comboParams.setEnabled(false);
        this.comboValue.setEditable(true);
        this.labelInstances.setHorizontalAlignment(4);
        this.labelInstances.setText(this.stringManager.getString("instance-dd"));
        this.comboInstances.setEditable(true);
        this.labelInstances1.setHorizontalAlignment(4);
        this.labelInstances1.setText(this.stringManager.getString("update-comment-dd"));
        this.groupScope.add(this.radioMemory);
        this.radioMemory.setText("MEMORY");
        this.groupScope.add(this.radioSpfile);
        this.radioSpfile.setSelected(true);
        this.radioSpfile.setText("SPFILE");
        this.groupScope.add(this.radioBoth);
        this.radioBoth.setText("BOTH");
        this.labelInstances2.setHorizontalAlignment(4);
        this.labelInstances2.setText(this.stringManager.getString("scope-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelInstances, -1, 133, Short.MAX_VALUE).addComponent(this.labelInstances2, -1, 133, Short.MAX_VALUE).addComponent(this.labelInstances1, -1, 133, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 133, Short.MAX_VALUE).addComponent(this.jLabel1, -1, 133, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.comboValue, -1, 322, Short.MAX_VALUE).addComponent((Component)this.editComment, -1, 322, Short.MAX_VALUE).addComponent((Component)this.comboInstances, -1, 322, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.radioMemory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioSpfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioBoth)).addComponent((Component)this.comboParams, -1, 322, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.comboParams, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboValue, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelInstances1).addComponent((Component)this.editComment, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioMemory).addComponent(this.radioSpfile).addComponent(this.radioBoth).addComponent(this.labelInstances2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.comboInstances, -2, -1, -2).addComponent(this.labelInstances)).addContainerGap(47, Short.MAX_VALUE)));
    }
}

