/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.services.OracleTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class CreateDatabaseTriggerWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);
    private Database database;
    private String schemaName;
    private Template template;
    private static String[] beforeEvents = new String[]{"ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DDL", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "LOGOFF", "NOAUDIT", "RENAME", "REVOKE", "SHUTDOWN", "TRUNCATE"};
    private static String[] afterEvents = new String[]{"ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DB_ROLE_CHANGE", "DDL", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "LOGON", "NOAUDIT", "RENAME", "REVOKE", "SERVERERROR", "STARTUP", "SUSPEND", "TRUNCATE"};
    private JButton buttonMoveAllRight;
    private JButton buttonMoveAllRight1;
    private JButton buttonMoveRight;
    private JButton buttonMoveRight1;
    private Action cmMoveAllLeft;
    private Action cmMoveAllRight;
    private Action cmMoveLeft;
    private Action cmMoveRight;
    private JComboBox comboType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelSelectedColumns;
    private JList listAvailEvents;
    private JList listSelectedEvents;
    private TextField textName;

    public CreateDatabaseTriggerWizard(Database database, String schemaName) {
        this.database = database;
        this.schemaName = schemaName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.comboType.setModel(new DefaultComboBoxModel<String>(new String[]{this.stringManager.getString("trigger-before-event"), this.stringManager.getString("trigger-after-event")}));
        this.listAvailEvents.setModel(new DefaultListModel());
        this.listSelectedEvents.setModel(new DefaultListModel());
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(OracleTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(OracleTemplatesSettingsProvider.setTrigger, "oracle-trigger"));
        this.updateEventList();
    }

    private void updateMoveActions() {
        this.cmMoveRight.setEnabled(this.listAvailEvents.getSelectedValue() != null);
        this.cmMoveAllRight.setEnabled(this.listAvailEvents.getModel().getSize() > 0);
        this.cmMoveLeft.setEnabled(this.listSelectedEvents.getSelectedValue() != null);
        this.cmMoveAllLeft.setEnabled(this.listSelectedEvents.getModel().getSize() > 0);
    }

    private void updateEventList() {
        DefaultListModel model = (DefaultListModel)this.listSelectedEvents.getModel();
        model.removeAllElements();
        model = (DefaultListModel)this.listAvailEvents.getModel();
        model.removeAllElements();
        for (String s : this.comboType.getSelectedIndex() == 0 ? beforeEvents : afterEvents) {
            model.addElement(s);
        }
        this.updateMoveActions();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateDatabaseTriggerWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateDatabaseTriggerWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        String type = this.comboType.getSelectedIndex() == 0 ? "BEFORE" : "AFTER";
        DefaultListModel sel = (DefaultListModel)this.listSelectedEvents.getModel();
        if (sel.getSize() > 0) {
            for (int i = 0; i < sel.getSize(); ++i) {
                if (i > 0) {
                    type = type + " OR";
                }
                type = type + " " + sel.getElementAt(i);
            }
        }
        if (this.template == null) {
            return "CREATE TRIGGER " + this.textName.getText() + "\n" + "  " + type + " ON DATABASE\n" + "BEGIN\n" + "  NULL;\n" + "END;";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", this.textName.getText());
        map.put("&type", "  " + type + " ON DATABASE");
        map.put("&body", "  NULL;");
        map.put("&description", "");
        return this.template.expand(map);
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmMoveRight = new Action();
        this.cmMoveAllRight = new Action();
        this.cmMoveLeft = new Action();
        this.cmMoveAllLeft = new Action();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel5 = new JLabel();
        this.comboType = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.listAvailEvents = new JList();
        this.buttonMoveRight = new JButton();
        this.buttonMoveAllRight = new JButton();
        this.buttonMoveRight1 = new JButton();
        this.buttonMoveAllRight1 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.listSelectedEvents = new JList();
        this.labelSelectedColumns = new JLabel();
        this.cmMoveRight.setActionCommandKey("cmMoveRight");
        this.cmMoveRight.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_right.gif"));
        this.cmMoveRight.setText(this.stringManager.getString("cmMoveRight-text"));
        this.cmMoveRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseTriggerWizard.this.cmMoveRightActionPerformed(evt);
            }
        });
        this.cmMoveAllRight.setActionCommandKey("cmMoveAllRight");
        this.cmMoveAllRight.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_all_right.gif"));
        this.cmMoveAllRight.setText(this.stringManager.getString("cmMoveAllRight-text"));
        this.cmMoveAllRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseTriggerWizard.this.cmMoveAllRightActionPerformed(evt);
            }
        });
        this.cmMoveLeft.setActionCommandKey("cmMoveLeft");
        this.cmMoveLeft.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_left.gif"));
        this.cmMoveLeft.setText(this.stringManager.getString("cmMoveLeft-text"));
        this.cmMoveLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseTriggerWizard.this.cmMoveLeftActionPerformed(evt);
            }
        });
        this.cmMoveAllLeft.setActionCommandKey("cmMoveAllLeft");
        this.cmMoveAllLeft.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/move_all_left.gif"));
        this.cmMoveAllLeft.setText(this.stringManager.getString("cmMoveAllLeft-text"));
        this.cmMoveAllLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateDatabaseTriggerWizard.this.cmMoveAllLeftActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("trigger-name-dd"));
        this.textName.setText("DATABASE_TRG");
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(this.stringManager.getString("trigger-type-dd"));
        this.comboType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CreateDatabaseTriggerWizard.this.comboTypeItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(this.stringManager.getString("available-events-dd"));
        this.listAvailEvents.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CreateDatabaseTriggerWizard.this.listAvailEventsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listAvailEvents);
        this.buttonMoveRight.setAction((javax.swing.Action)this.cmMoveRight);
        this.buttonMoveRight.setHideActionText(true);
        this.buttonMoveRight.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveRight.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveAllRight.setAction((javax.swing.Action)this.cmMoveAllRight);
        this.buttonMoveAllRight.setHideActionText(true);
        this.buttonMoveAllRight.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveAllRight.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveRight1.setAction((javax.swing.Action)this.cmMoveLeft);
        this.buttonMoveRight1.setHideActionText(true);
        this.buttonMoveRight1.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveRight1.setPreferredSize(new Dimension(50, 23));
        this.buttonMoveAllRight1.setAction((javax.swing.Action)this.cmMoveAllLeft);
        this.buttonMoveAllRight1.setHideActionText(true);
        this.buttonMoveAllRight1.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMoveAllRight1.setPreferredSize(new Dimension(50, 23));
        this.listSelectedEvents.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CreateDatabaseTriggerWizard.this.listSelectedEventsValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.listSelectedEvents);
        this.labelSelectedColumns.setText(this.stringManager.getString("selected-events-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 225, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboType, 0, 225, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 150, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonMoveAllRight1, -2, 38, -2).addComponent(this.buttonMoveRight1, -2, 38, -2).addComponent(this.buttonMoveAllRight, -2, 38, -2).addComponent(this.buttonMoveRight, -2, 38, -2))).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 156, Short.MAX_VALUE).addComponent(this.labelSelectedColumns)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labelSelectedColumns)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 110, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(85, 85, 85).addComponent(this.buttonMoveRight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveAllRight, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveRight1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveAllRight1, -2, -1, -2))).addContainerGap()));
    }

    private void comboTypeItemStateChanged(ItemEvent evt) {
        this.updateEventList();
    }

    private void listAvailEventsValueChanged(ListSelectionEvent evt) {
        this.updateMoveActions();
    }

    private void listSelectedEventsValueChanged(ListSelectionEvent evt) {
        this.updateMoveActions();
    }

    private void cmMoveRightActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedEvents.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailEvents.getModel();
        sel.addElement(this.listAvailEvents.getSelectedValue());
        tab.removeElement(this.listAvailEvents.getSelectedValue());
        this.updateMoveActions();
    }

    private void cmMoveLeftActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedEvents.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailEvents.getModel();
        tab.addElement(this.listSelectedEvents.getSelectedValue());
        sel.removeElement(this.listSelectedEvents.getSelectedValue());
        this.updateMoveActions();
    }

    private void cmMoveAllRightActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedEvents.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailEvents.getModel();
        for (int i = 0; i < tab.getSize(); ++i) {
            sel.addElement(tab.get(i));
        }
        tab.removeAllElements();
        this.updateMoveActions();
    }

    private void cmMoveAllLeftActionPerformed(ActionEvent evt) {
        DefaultListModel sel = (DefaultListModel)this.listSelectedEvents.getModel();
        DefaultListModel tab = (DefaultListModel)this.listAvailEvents.getModel();
        for (int i = 0; i < sel.getSize(); ++i) {
            tab.addElement(sel.get(i));
        }
        sel.removeAllElements();
        this.updateMoveActions();
    }
}

