/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.services;

import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.Sql;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class OracleDbaDatabaseProvider
extends DatabaseProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Oracle".equals(database.getDriverType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnection(Database database) {
        block24: {
            Query query = database.createQuery();
            try {
                if (!StringUtil.toBoolean((String)database.getUserProperties().getProperty("dba-role"))) {
                    query.open(Sql.getLockViewRole());
                    if (query.fieldByName("cnt").getInteger() == 3) {
                        database.getUserProperties().put("lock-view-role", "true");
                    } else {
                        database.getUserProperties().put("lock-view-role", "false");
                    }
                    query.open(Sql.getSessionViewRole());
                    if (query.fieldByName("cnt").getInteger() == 3) {
                        database.getUserProperties().put("session-view-role", "true");
                    } else {
                        database.getUserProperties().put("session-view-role", "false");
                    }
                    query.open(Sql.getSqlViewRole());
                    if (query.fieldByName("cnt").getInteger() == 2) {
                        database.getUserProperties().put("sql-view-role", "true");
                    } else {
                        database.getUserProperties().put("sql-view-role", "false");
                    }
                    query.open(Sql.getSessStatViewRole());
                    if (query.fieldByName("cnt").getInteger() == 2) {
                        database.getUserProperties().put("sess-stat-view-role", "true");
                    } else {
                        database.getUserProperties().put("sess-stat-view-role", "false");
                    }
                } else {
                    database.getUserProperties().put("lock-view-role", "true");
                    database.getUserProperties().put("session-view-role", "true");
                    database.getUserProperties().put("sql-view-role", "true");
                    database.getUserProperties().put("sess-stat-view-role", "true");
                }
                if (StringUtil.toBoolean((String)database.getUserProperties().getProperty("session-view-role", "false"))) {
                    try {
                        query.open(Sql.getSessionId());
                        if (!query.eof()) {
                            database.getUserProperties().put("sid", query.fieldByName("sid").getString());
                            database.getUserProperties().put("serial", query.fieldByName("serial").getString());
                            database.getUserProperties().put("sessionid", query.fieldByName("audsid").getString());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    try {
                        try {
                            query.open(Sql.getClusterDetect_GV());
                        }
                        catch (Exception ex) {
                            query.open(Sql.getClusterDetect_V());
                        }
                        if (query.fieldByName("gvcount").getInteger() > 1) {
                            database.getUserProperties().put("rac-detect", "true");
                            break block24;
                        }
                        database.getUserProperties().put("rac-detect", "false");
                    }
                    catch (Exception ex) {
                        database.getUserProperties().put("rac-detect", "false");
                    }
                    break block24;
                }
                database.getUserProperties().put("rac-detect", "false");
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
            finally {
                query.close();
            }
        }
    }

    public void beforeDisconnect(Database database) {
    }

    public String getDescription() {
        return this.stringManager.getString("OracleDbaDatabaseProvider-description");
    }

    public String getGroupName() {
        return "Oracle";
    }
}

