/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.services;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.gui.sessions.LocksPanelView;
import pl.mpak.orbada.oracle.dba.gui.sessions.SessionsPanelView;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OracleKillSessionAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (OracleKillSessionAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)OracleKillSessionAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        int result;
                        SessionsPanelView spv = (SessionsPanelView)((Object)SwingUtil.getOwnerComponent(SessionsPanelView.class, (Component)OracleKillSessionAction.this.getComponent()));
                        LocksPanelView lpv = (LocksPanelView)((Object)SwingUtil.getOwnerComponent(LocksPanelView.class, (Component)OracleKillSessionAction.this.getComponent()));
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String session = vt.getQuery().fieldByName("sid").getInteger() + ", " + vt.getQuery().fieldByName("serial#").getInteger();
                        if (vt.getQuery().findFieldByName("inst_id") != null) {
                            session = session + ", @" + vt.getQuery().fieldByName("inst_id").getInteger();
                        }
                        if ((result = MessageBox.show((Component)(spv != null ? spv : (lpv != null ? lpv : OracleKillSessionAction.this.getComponent())), (String)OracleKillSessionAction.this.stringManager.getString("session"), (String)OracleKillSessionAction.this.stringManager.getString("kill-selected-session-q", (Object)session), (String[])new String[]{OracleKillSessionAction.this.stringManager.getString("kill-selected-yes"), OracleKillSessionAction.this.stringManager.getString("kill-selected-immediate"), OracleKillSessionAction.this.stringManager.getString("kill-selected-no")}, (int)3)) == 0 || result == 1) {
                            OracleKillSessionAction.this.getDatabase().executeCommand("ALTER SYSTEM KILL SESSION '" + session + "'" + (result == 1 ? " IMMEDIATE" : ""));
                            if (spv != null) {
                                spv.refresh();
                            } else if (lpv != null) {
                                lpv.refresh();
                            } else {
                                vt.getQuery().refresh();
                            }
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)OracleKillSessionAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"Oracle".equals(database.getDriverType())) {
            return false;
        }
        if (!"oracle-sessions-actions".equals(actionType) && !"oracle-session-locks-actions".equals(actionType)) {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("OracleKillSessionAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/stop16.gif"));
        this.setActionCommandKey("OracleKillSessionAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("OracleKillSessionAction-description");
    }

    public String getGroupName() {
        return "Oracle";
    }

    public boolean isToolButton() {
        return true;
    }
}

