/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.services;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.gui.wizards.LoggingTableWizard;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OracleLoggingTableAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (OracleLoggingTableAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)OracleLoggingTableAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String schemaName = vt.getQuery().fieldByName("schema_name").getString();
                        String tableName = vt.getQuery().fieldByName("table_name").getString();
                        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new LoggingTableWizard(OracleLoggingTableAction.this.getDatabase(), schemaName, tableName), (boolean)true);
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)OracleLoggingTableAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"Oracle".equals(database.getDriverType())) {
            return false;
        }
        if (!"oracle-tables-actions".equals(actionType)) {
            return false;
        }
        this.setText(this.getDescription());
        this.setActionCommandKey("OracleLoggingTableAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("OracleLoggingTableAction-description");
    }

    public String getGroupName() {
        return "Oracle";
    }
}

