/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.oracle.dba.services;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.oracle.dba.OrbadaOracleDbaPlugin;
import pl.mpak.orbada.oracle.dba.gui.wizards.RebuildIndexWizard;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class OracleRebuildIndexAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaOracleDbaPlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (OracleRebuildIndexAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)OracleRebuildIndexAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String schemaName = vt.getQuery().fieldByName("schema_name").getString();
                        String indexName = vt.getQuery().fieldByName("index_name").getString();
                        String tableName = vt.getQuery().fieldByName("table_name").getString();
                        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new RebuildIndexWizard(OracleRebuildIndexAction.this.getDatabase(), schemaName, tableName, indexName), (boolean)true);
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)OracleRebuildIndexAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"Oracle".equals(database.getDriverType())) {
            return false;
        }
        if (!"oracle-indexes-actions".equals(actionType) && !"oracle-table-indexes-actions".equals(actionType)) {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("OracleRebuildIndexAction-hint"));
        this.setActionCommandKey("OracleRebuildIndexAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("OracleRebuildIndexAction-description");
    }

    public String getGroupName() {
        return "Oracle";
    }
}

