/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.sqlite.services.ExplainPlanProvider;
import pl.mpak.orbada.sqlite.services.SQLiteDatabaseProvider;
import pl.mpak.orbada.sqlite.services.SQLiteDatabasesView;
import pl.mpak.orbada.sqlite.services.SQLiteDbInfoProvider;
import pl.mpak.orbada.sqlite.services.SQLitePerspectiveProvider;
import pl.mpak.orbada.sqlite.services.SQLiteTablesView;
import pl.mpak.orbada.sqlite.services.SQLiteTriggersView;
import pl.mpak.orbada.sqlite.services.SQLiteViewsView;
import pl.mpak.orbada.sqlite.services.actions.AttachDatabaseAction;
import pl.mpak.orbada.sqlite.services.actions.DetachDatabaseAction;
import pl.mpak.orbada.sqlite.services.actions.DropTableAction;
import pl.mpak.orbada.sqlite.services.actions.DropTriggerAction;
import pl.mpak.orbada.sqlite.services.actions.DropViewAction;
import pl.mpak.orbada.sqlite.services.actions.FreezeAction;
import pl.mpak.orbada.sqlite.services.actions.PragmaDatabaseCacheSizeAction;
import pl.mpak.orbada.sqlite.services.actions.PragmaDatabaseIntegrityCheckAction;
import pl.mpak.orbada.sqlite.services.actions.PragmaDatabaseLockingModeAction;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaSQLitePlugin
extends OrbadaPlugin {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    public static final String driverType = "SQLite";
    public static final VersionID version = new VersionID(2, 0, 0, 15);
    public static final ArrayList<Class<? extends IPluginProvider>> classList = new ArrayList();

    public String getInternalName() {
        return "OrbadaSQLitePlugin";
    }

    public String getDescriptiveName() {
        return String.format(this.stringManager.getString("OrbadaSQLitePlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,SQLite";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return version.toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-sqlite-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        this.application.registerDriverType(driverType);
        classList.add(SQLiteDbInfoProvider.class);
        classList.add(SQLiteDatabaseProvider.class);
        classList.add(SQLiteTablesView.class);
        classList.add(SQLiteViewsView.class);
        classList.add(SQLiteTriggersView.class);
        classList.add(SQLiteDatabasesView.class);
        classList.add(DropTableAction.class);
        classList.add(DropViewAction.class);
        classList.add(DropTriggerAction.class);
        classList.add(FreezeAction.class);
        classList.add(AttachDatabaseAction.class);
        classList.add(DetachDatabaseAction.class);
        classList.add(SQLitePerspectiveProvider.class);
        classList.add(PragmaDatabaseLockingModeAction.class);
        classList.add(PragmaDatabaseCacheSizeAction.class);
        classList.add(PragmaDatabaseIntegrityCheckAction.class);
        this.initTemplates();
    }

    public boolean requires(List<IPlugin> loadedPlugins) {
        this.addDepend("orbada-universal-plugin");
        for (IPlugin plugin : loadedPlugins) {
            if (!"orbada-universal-plugin".equals(plugin.getUniqueID())) continue;
            classList.add(ExplainPlanProvider.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTemplates() {
        if (InternalDatabase.get() == null) {
            return;
        }
        Database database = InternalDatabase.get();
        Query query = database.createQuery();
        query.close();
    }
}

