/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.cm;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DatabaseVacuumAction
extends Action {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    private Database database;

    public DatabaseVacuumAction(Database database) {
        this.database = database;
        this.setText(this.stringManager.getString("DatabaseVacuumAction-text"));
        this.setTooltip(this.stringManager.getString("DatabaseVacuumAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/cleaning.gif"));
        this.setActionCommandKey("VacuumAction");
        this.addActionListener(this.createActionListener());
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DatabaseVacuumAction.this.stringManager.getString("execute"), (String)DatabaseVacuumAction.this.stringManager.getString("DatabaseVacuumAction-go-q-info"), (int[])ModalResult.YESNO, (int)1) == 5) {
                    try {
                        DatabaseVacuumAction.this.database.executeCommand("VACUUM");
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)DatabaseVacuumAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }
}

