/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ExplainPlanPanel
extends JPanel
implements Closeable {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    private Database database;
    private DataTable data;
    private DataTable dataStats;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private QueryTableStatusBar statusBar;
    private QueryTableStatusBar statusBarStats;

    public ExplainPlanPanel(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void updatePlan(String sqlText) {
        this.data.getQuery().setDatabase(this.database);
        this.dataStats.getQuery().setDatabase(this.database);
        try {
            Query query = this.database.createQuery();
            query.setSqlText(sqlText);
            Command command = this.database.createCommand();
            command.execute("EXPLAIN QUERY PLAN \n" + query.getPreparedSqlText());
            if (command.getStatement() != null) {
                this.data.getQuery().close();
                this.data.getQuery().setResultSet(command.getStatement().getResultSet());
            }
            query.setSqlText(sqlText);
            command.execute("EXPLAIN \n" + query.getPreparedSqlText());
            if (command.getStatement() != null) {
                this.dataStats.getQuery().close();
                this.dataStats.getQuery().setResultSet(command.getStatement().getResultSet());
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void close() throws IOException {
        this.data.getQuery().close();
        this.dataStats.getQuery().close();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.statusBar = new QueryTableStatusBar();
        this.jScrollPane1 = new JScrollPane();
        this.data = new DataTable();
        this.jPanel2 = new JPanel();
        this.statusBarStats = new QueryTableStatusBar();
        this.jScrollPane2 = new JScrollPane();
        this.dataStats = new DataTable();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setFocusable(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.statusBar.setTable((QueryTable)this.data);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.jScrollPane1.setViewportView((Component)this.data);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jTabbedPane1.addTab(this.stringManager.getString("ExplainPlanPanel-tab_plan"), this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.statusBarStats.setTable((QueryTable)this.dataStats);
        this.jPanel2.add((Component)this.statusBarStats, "South");
        this.jScrollPane2.setViewportView((Component)this.dataStats);
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jTabbedPane1.addTab(this.stringManager.getString("ExplainPlanPanel-tab_stats"), this.jPanel2);
        this.add((Component)this.jTabbedPane1, "Center");
    }
}

