/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.gui.databases;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.Sql;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class DatabasesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    private IViewAccesibilities accesibilities;
    private String tabTitle;
    private boolean viewClosing = false;
    private ISettings settings;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JSplitPane split;
    private QueryTableStatusBar statusBar;
    private QueryTableStatusBar statusBarDetails;
    private ViewTable tableDatabases;
    private DataTable tableDetails;
    private JToolBar toolBar;

    public DatabasesPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "sqlite-database-panel");
        this.tableDetails.getQuery().setDatabase(this.getDatabase());
        this.tableDatabases.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableDatabases.getQuery().setCloseResultAfterOpen(true);
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("seq", this.stringManager.getString("pos"), 50));
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("name", this.stringManager.getString("database-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("file", this.stringManager.getString("file"), 450));
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("file_size", this.stringManager.getString("file-size"), 70));
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("cache_size", this.stringManager.getString("cache-size"), 70));
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("page_count", this.stringManager.getString("page-count"), 70));
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("max_page_count", this.stringManager.getString("max-page-count"), 80));
            this.tableDatabases.addColumn((TableColumn)new QueryTableColumn("locking_mode", this.stringManager.getString("locking-mode"), 100));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        this.tableDatabases.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DatabasesPanelView.this.tableDetails.getQuery().close();
            }
        });
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableDatabases, (JButton)this.buttonActions, this.menuActions, "sqlite-databases-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DatabasesPanelView.this.split.setDividerLocation(DatabasesPanelView.this.settings.getValue("split-location", Long.valueOf((long)((double)DatabasesPanelView.this.split.getHeight() * 0.8))).intValue());
            }
        });
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.tableDatabases.getQuery().isActive() && this.tableDatabases.getSelectedRow() >= 0) {
                this.tableDatabases.getQuery().getRecord(this.tableDatabases.getSelectedRow());
                objectName = this.tableDatabases.getQuery().fieldByName("name").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createDatabasesSQL() throws Exception {
        Query query = this.getDatabase().createQuery();
        Query pragma = this.getDatabase().createQuery();
        StringBuilder sb = new StringBuilder();
        try {
            query.open(Sql.getCatalogList());
            while (!query.eof()) {
                if (sb.length() > 0) {
                    sb.append("UNION ALL\n");
                }
                sb.append("SELECT ");
                sb.append("'").append(query.fieldByName("seq").getString()).append("' seq");
                sb.append(", '").append(query.fieldByName("name").getString()).append("' name");
                sb.append(", '").append(query.fieldByName("file").getString()).append("' file");
                sb.append(", ").append(new File(query.fieldByName("file").getString()).length()).append(" file_size");
                sb.append(", ").append(pragma.open("pragma " + this.getDatabase().quoteName(query.fieldByName("name").getString()) + ".cache_size").fieldByName("cache_size").getString()).append(" cache_size");
                sb.append(", ").append(pragma.open("pragma " + this.getDatabase().quoteName(query.fieldByName("name").getString()) + ".page_count").fieldByName("page_count").getString()).append(" page_count");
                sb.append(", ").append(pragma.open("pragma " + this.getDatabase().quoteName(query.fieldByName("name").getString()) + ".max_page_count").fieldByName("max_page_count").getString()).append(" max_page_count");
                sb.append(", '").append(pragma.open("pragma " + this.getDatabase().quoteName(query.fieldByName("name").getString()) + ".locking_mode").fieldByName("locking_mode").getString()).append("' locking_mode");
                sb.append("\n");
                query.next();
            }
        }
        finally {
            pragma.close();
            query.close();
        }
        return sb.toString();
    }

    public void refresh(String objectName) {
        try {
            int column = this.tableDatabases.getSelectedColumn();
            int index = Math.max(0, this.tableDatabases.getSelectedRow());
            this.tableDatabases.getQuery().close();
            this.tableDatabases.getQuery().setSqlText(this.createDatabasesSQL());
            this.tableDatabases.getQuery().open();
            if (objectName != null && this.tableDatabases.getQuery().locate("name", new Variant(objectName))) {
                this.tableDatabases.changeSelection(this.tableDatabases.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.tableDatabases.getQuery().isEmpty()) {
                this.tableDatabases.changeSelection(Math.min(index, this.tableDatabases.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.settings.setValue("split-location", Long.valueOf(this.split.getDividerLocation()));
        this.viewClosing = true;
        this.tableDatabases.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    public Query getQueryDetails() {
        return this.tableDetails.getQuery();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.split = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableDatabases = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tableDetails = new DataTable();
        this.statusBarDetails = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/refresh16.gif")));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DatabasesPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                DatabasesPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(201);
        this.split.setOrientation(0);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel3.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableDatabases);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.tableDatabases);
        this.jPanel3.add((Component)this.statusBar, "South");
        this.split.setTopComponent(this.jPanel3);
        this.jPanel4.setLayout(new BorderLayout());
        this.jScrollPane2.setViewportView((Component)this.tableDetails);
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.statusBarDetails.setShowFieldType(false);
        this.statusBarDetails.setShowOpenTime(false);
        this.statusBarDetails.setTable((QueryTable)this.tableDetails);
        this.jPanel4.add((Component)this.statusBarDetails, "South");
        this.split.setBottomComponent(this.jPanel4);
        this.jPanel1.add((Component)this.split, "Center");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.add((Component)this.jPanel2, "North");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.tableDatabases.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }
}

