/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PragmaAutoVacuumWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    private Database database;
    private JLabel jLabel1;
    private ComboBox textVacuum;

    public PragmaAutoVacuumWizard(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardShow() {
        try {
            Query query = this.database.createQuery("PRAGMA AUTO_VACUUM");
            try {
                if ("0".equals(query.fieldByName("auto_vacuum").getString())) {
                    this.textVacuum.setText("NONE");
                } else if ("1".equals(query.fieldByName("auto_vacuum").getString())) {
                    this.textVacuum.setText("FULL");
                } else if ("2".equals(query.fieldByName("auto_vacuum").getString())) {
                    this.textVacuum.setText("INCREMENTAL");
                } else {
                    this.textVacuum.setText(query.fieldByName("auto_vacuum").getString());
                }
            }
            finally {
                query.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDialogTitle() {
        return this.stringManager.getString("auto-vacuum");
    }

    public String getTabTitle() {
        return this.stringManager.getString("setting");
    }

    public String getSqlCode() {
        return "PRAGMA AUTO_VACUUM = " + this.textVacuum.getText() + "\n/\nVACUUM\n/";
    }

    public boolean execute() {
        try {
            this.database.executeScript(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textVacuum = new ComboBox();
        this.jLabel1.setText(this.stringManager.getString("auto-vacuum-dd"));
        this.textVacuum.setModel(new DefaultComboBoxModel<String>(new String[]{"NONE", "FULL", "INCREMENTAL"}));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textVacuum, -2, 145, -2).addContainerGap(120, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textVacuum, -2, -1, -2)).addContainerGap(41, Short.MAX_VALUE)));
    }
}

