/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class PragmaCacheSizeWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    private Database database;
    private String databaseName;
    private JLabel jLabel1;
    private ComboBox textCacheSize;

    public PragmaCacheSizeWizard(Database database, String databaseName) {
        this.database = database;
        this.databaseName = databaseName;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardShow() {
        try {
            Query query = this.database.createQuery("PRAGMA " + (this.databaseName != null ? SQLUtil.createSqlName((String)this.databaseName, (Database)this.database) + "." : "") + "CACHE_SIZE");
            try {
                this.textCacheSize.setText(query.fieldByName("cache_size").getString());
            }
            finally {
                query.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDialogTitle() {
        return this.stringManager.getString("cache-size");
    }

    public String getTabTitle() {
        return this.stringManager.getString("size");
    }

    public String getSqlCode() {
        return "PRAGMA " + (this.databaseName != null ? SQLUtil.createSqlName((String)this.databaseName, (Database)this.database) + "." : "") + "CACHE_SIZE = " + this.textCacheSize.getText();
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.textCacheSize = new ComboBox();
        this.jLabel1.setText(this.stringManager.getString("cache-size-dd"));
        this.textCacheSize.setEditable(true);
        this.textCacheSize.setModel(new DefaultComboBoxModel<String>(new String[]{"2000", "4000", "8000", "16000"}));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textCacheSize, -2, 139, -2).addContainerGap(111, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent((Component)this.textCacheSize, -2, -1, -2)).addContainerGap(41, Short.MAX_VALUE)));
    }
}

