/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.gui.ExplainPlanPanel;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ExplainPlanProvider
extends UniversalActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    public ExplainPlanProvider() {
        this.setShortCut(69, 2);
        this.setText(this.stringManager.getString("ExplainPlanProvider-text"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/explain_plan.gif"));
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "SQLite".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return true;
    }

    public boolean addMenuItem() {
        return false;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("ExplainPlanProvider-description");
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String sqlCode = this.accessibilities.getSyntaxEditor().getCurrentText();
        Component[] array = this.accessibilities.getResultTabs(ExplainPlanPanel.class);
        if (array.length > 0) {
            ExplainPlanPanel panel = (ExplainPlanPanel)array[0];
            panel.updatePlan(sqlCode);
            this.accessibilities.setSelectedTab((Component)panel);
        } else {
            ExplainPlanPanel panel = new ExplainPlanPanel(this.accessibilities.getViewAccesibilities().getDatabase());
            panel.updatePlan(sqlCode);
            this.accessibilities.addResultTab(this.getText(), (JComponent)panel);
        }
    }

    public String getGroupName() {
        return "SQLite";
    }
}

