/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services;

import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SQLiteDatabaseProvider
extends DatabaseProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "SQLite".equals(database.getDriverType());
    }

    public void afterConnection(Database database) {
        database.getUserProperties().put("dict-persistent-query", "true");
    }

    public void beforeDisconnect(Database database) {
    }

    public String getDescription() {
        return this.stringManager.getString("SQLiteDatabaseProvider-description");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

