/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services;

import java.awt.Component;
import javax.swing.Icon;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.gui.databases.DatabasesPanelView;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SQLiteDatabasesView
extends ViewProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    public Component createView(IViewAccesibilities accesibilities) {
        return new DatabasesPanelView(accesibilities);
    }

    public boolean isDefaultView() {
        return false;
    }

    public String getPublicName() {
        return this.stringManager.getString("SQLiteDatabasesView-public-name");
    }

    public String getViewId() {
        return "orbada-sqlite-databases-view";
    }

    public Icon getIcon() {
        return ImageManager.getImage((String)"/pl/mpak/res/icons/databases.gif");
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "SQLite".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("SQLiteDatabasesView-description");
    }

    public String getGroupName() {
        return "SQLite";
    }

    public String[] getSubmenu() {
        return null;
    }
}

