/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services;

import java.awt.Component;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.jdbc.JdbcDbDatabaseInfo;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseListener;
import pl.mpak.usedb.core.ExecutableListener;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.id.VersionID;

public class SQLiteDbInfoProvider
extends DatabaseInfoProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);
    public static SQLiteDbInfoProvider instance;
    private HashMap<String, DbDatabaseInfo> databaseInfoList;
    private HashMap<String, HashMap<String, String[]>> databaseStringList;

    public SQLiteDbInfoProvider() {
        instance = this;
        if (this.databaseInfoList == null) {
            this.databaseInfoList = new HashMap();
        }
        if (this.databaseStringList == null) {
            this.databaseStringList = new HashMap();
        }
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "SQLite".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("SQLiteDbInfoProvider-description");
    }

    public String getBanner(Database database) {
        return String.format(this.stringManager.getString("SQLiteDbInfoProvider-banner"), this.getVersion(database));
    }

    private String getUniqueName(Database database) {
        return database.getUniqueID();
    }

    public void resetDatabaseInfo(Database database) {
        this.databaseInfoList.remove(this.getUniqueName(database));
        this.databaseStringList.remove(this.getUniqueName(database));
    }

    private String[] getStrings(Database database, String type) {
        HashMap<String, String[]> result = this.databaseStringList.get(this.getUniqueName(database));
        if (result == null) {
            return null;
        }
        return result.get(type);
    }

    public String[] putStrings(Database database, String type, String[] array) {
        HashMap<String, Object> list = this.databaseStringList.get(this.getUniqueName(database));
        if (list == null) {
            list = new HashMap();
            this.databaseStringList.put(this.getUniqueName(database), list);
        }
        list.put(type, array);
        return array;
    }

    public String[] getKeywords(Database database) {
        String[] list = new String[]{"ABORT", "ADD", "AFTER", "ALTER", "ANALYZE", "AS", "ASC", "ATTACH", "AND", "AUTOINCREMENT", "BEFORE", "BEGIN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "DATABASE", "DEFAULT", "SELECT", "UPDATE", "WHERE", "UNION", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXPLAIN", "FAIL", "FOR", "FOREIGN", "FROM", "FULL", "GLOB", "GROUP", "HAVING", "IF", "IGNORE", "IMMEDIATE", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "ISNULL", "JOIN", "KEY", "LEFT", "LIMIT", "MATCH", "NATURAL", "NOTNULL", "NULL", "OF", "OFFSET", "ON", "OR", "ORDER", "OUTER", "PLAN", "PRAGMA", "PRIMARY", "QUERY", "RAISE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "TRUNCATE", "PERSIST", "MEMORY", "OFF", "NORMAL", "EXCLUDE", "TABLE", "VIEW", "TRIGGER", "TRANSACTION", "VALUES", "ROLLBACK", "VACUUM", "ROW"};
        return list;
    }

    public String[] getOperators(Database database) {
        String[] list = new String[]{"ALL", "ANY", "BETWEEN", "IN", "IS", "LIKE", "NOT", "EXISTS"};
        return list;
    }

    public String[] getUserTables(Database database) {
        String[] array = this.getStrings(database, "USER_TABLES");
        if (array == null) {
            array = this.putStrings(database, "USER_TABLES", QueryUtil.queryToArray((Database)database, (String)"select name from sqlite_master where type = 'table'"));
        }
        return array;
    }

    public String[] getExceptions(Database database) {
        String[] array = this.getStrings(database, "EXCEPTIONS");
        return array;
    }

    public String[] getSqlFunctions(Database database) {
        String[] list = new String[]{"CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "strftime", "DATE", "TIME", "DATETIME", "avg", "count", "group_concat", "max", "min", "total", "abs", "changes", "coalesce", "glob", "ifnull", "hex", "last_insert_rowid", "length", "load_extension", "lower", "ltrim", "nullif", "quote", "random", "randomblob", "replace", "round", "rtrim", "soundex", "sqlite_version", "substr", "total_changes", "trim", "typeof", "upper", "zeroblob"};
        return list;
    }

    public String[] getUserFunctions(Database database) {
        String[] array = this.getStrings(database, "USER_FUNCTIONS");
        return array;
    }

    public String[] getPublicTables(Database database) {
        String[] array = new String[]{"sqlite_master", "sqlite_temp_master", "auto_vacuum", "cache_size", "case_sensitive_like", "count_changes", "default_cache_size", "empty_result_callbacks", "encoding", "full_column_names", "fullfsync", "incremental_vacuum", "journal_mode", "journal_size_limit", "legacy_file_format", "locking_mode", "page_size", "max_page_count", "read_uncommitted", "reverse_unordered_selects", "short_column_names", "synchronous", "temp_store", "temp_store_directory", "collation_list", "database_list", "foreign_key_list", "freelist_count", "index_info", "index_list", "page_count", "table_info", "schema_version", "user_version", "integrity_check", "quick_check", "parser_trace", "vdbe_trace", "vdbe_listing"};
        array = StringUtil.unionList((String[])array, (String[])this.getCatalogs(database));
        return array;
    }

    public String[] getDataTypes(Database database) {
        String[] types = new String[]{"TEXT", "NUMBER", "BLOB", "INTEGER", "NUMERIC", "REAL", "NONE", "AUTOINC", "VARCHAR", "BOOLEAN"};
        return types;
    }

    public String[] getSchemas(Database database) {
        return this.getCatalogs(database);
    }

    public String[] getCatalogs(Database database) {
        String[] array = this.getStrings(database, "CATALOGS");
        if (array == null) {
            array = this.putStrings(database, "CATALOGS", QueryUtil.queryToArray((Database)database, (String)"{name}", (String)"PRAGMA database_list"));
        }
        return array;
    }

    public String getCurrentCatalog() {
        return "main";
    }

    public String[] getTableTypes(Database database) {
        String[] tableTypes = new String[]{"TABLE", "VIEW"};
        return tableTypes;
    }

    public Component[] getExtendedPanelInfo(Database database) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion(Database database) {
        Query query = database.createQuery();
        try {
            query.open("select sqlite_version() v");
            String string = new VersionID(query.fieldByName("v").getString()).toString();
            return string;
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            query.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbDatabaseInfo getDatabaseInfo(final Database database) {
        SQLiteDbInfoProvider sQLiteDbInfoProvider = this;
        synchronized (sQLiteDbInfoProvider) {
            DbDatabaseInfo info = this.databaseInfoList.get(this.getUniqueName(database));
            if (info == null) {
                info = new JdbcDbDatabaseInfo(database);
                this.databaseInfoList.put(this.getUniqueName(database), info);
                database.addDatabaseListener(new DatabaseListener(){

                    public void beforeConnect(EventObject e) {
                    }

                    public void afterConnect(EventObject e) {
                    }

                    public void beforeDisconnect(EventObject e) {
                    }

                    public void afterDisconnect(EventObject e) {
                        SQLiteDbInfoProvider.this.databaseInfoList.remove(SQLiteDbInfoProvider.this.getUniqueName(database));
                        SQLiteDbInfoProvider.this.databaseStringList.remove(SQLiteDbInfoProvider.this.getUniqueName(database));
                    }
                });
                database.addExecutableListener(new ExecutableListener(){

                    public boolean canExecute(EventObject e) throws SQLException {
                        return SQLiteDbInfoProvider.this.parseCommand((ParametrizedCommand)e.getSource());
                    }
                });
            }
            return info;
        }
    }

    private boolean parseCommand(ParametrizedCommand command) throws SQLException {
        return true;
    }

    public String[] getUniqueIdentFields(Database database, String catalogName, String schemaName, String tableName) {
        String[] result = super.getUniqueIdentFields(database, catalogName, schemaName, tableName);
        if (result == null || result.length == 0) {
            return new String[]{"ROWID"};
        }
        return result;
    }

    public String getGroupName() {
        return "SQLite";
    }
}

