/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.plugins.IDatabaseObject;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.cm.DatabaseVacuumAction;
import pl.mpak.orbada.sqlite.cm.PragmaAutoVacuumAction;
import pl.mpak.orbada.sqlite.cm.PragmaCacheSizeAction;
import pl.mpak.orbada.sqlite.cm.PragmaCaseSensitiveLikeAction;
import pl.mpak.orbada.sqlite.cm.PragmaLockingModeAction;
import pl.mpak.orbada.sqlite.cm.PragmaMaxPageCountAction;
import pl.mpak.orbada.sqlite.gui.freezing.FreezeFactory;
import pl.mpak.orbada.sqlite.gui.freezing.FreezeViewService;
import pl.mpak.orbada.sqlite.services.actions.AttachDatabaseAction;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class SQLitePerspectiveProvider
extends PerspectiveProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "SQLite".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("SQLitePerspectiveProvider-description");
    }

    public String getGroupName() {
        return "SQLite";
    }

    public void initialize() {
        final AttachDatabaseAction attachDatabaseAction = new AttachDatabaseAction(this.accesibilities.getDatabase());
        final DatabaseVacuumAction databaseVacuumAction = new DatabaseVacuumAction(this.accesibilities.getDatabase());
        final JMenu sqLite = new JMenu("SQLite");
        final JToolBar toolBar = new JToolBar("SQLite");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                sqLite.add((Action)((Object)attachDatabaseAction));
                sqLite.add((Action)((Object)databaseVacuumAction));
                sqLite.addSeparator();
                sqLite.add((Action)((Object)new PragmaCacheSizeAction(SQLitePerspectiveProvider.this.accesibilities.getDatabase())));
                sqLite.add((Action)((Object)new PragmaCaseSensitiveLikeAction(SQLitePerspectiveProvider.this.accesibilities.getDatabase())));
                sqLite.add((Action)((Object)new PragmaMaxPageCountAction(SQLitePerspectiveProvider.this.accesibilities.getDatabase())));
                sqLite.add((Action)((Object)new PragmaAutoVacuumAction(SQLitePerspectiveProvider.this.accesibilities.getDatabase())));
                sqLite.add((Action)((Object)new PragmaLockingModeAction(SQLitePerspectiveProvider.this.accesibilities.getDatabase())));
                toolBar.add((Component)new ToolButton((Action)((Object)attachDatabaseAction)));
                toolBar.add((Component)new ToolButton((Action)((Object)databaseVacuumAction)));
            }
        });
        this.accesibilities.addMenu(sqLite);
        this.accesibilities.addToolBar(toolBar);
    }

    public void processMessage(PluginMessage message) {
        if (this.getAccesibilities() != null && this.getAccesibilities().getDatabase() != null && this.getAccesibilities().getDatabase().getUniqueID().equals(message.getDestinationId()) && message.isMessageId("freeze-object")) {
            final IDatabaseObject object = (IDatabaseObject)message.getObject();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FreezeViewService service = new FreezeFactory().createInstance(object.getObjectType(), StringUtil.nvl((String)object.getSchemaName(), (String)object.getCatalogName()), object.getObjectName());
                    IPerspectiveAccesibilities accessibilities = SQLitePerspectiveProvider.this.application.getActivePerspective();
                    if (service != null && accessibilities != null) {
                        accessibilities.createView((ViewProvider)service);
                    }
                }
            });
            message.setServed(true);
        }
    }
}

