/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.orbada.sqlite.gui.wizards.AttachDatabaseWizard;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class AttachDatabaseAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    public AttachDatabaseAction() {
    }

    public AttachDatabaseAction(Database database) {
        this.setDatabase(database);
        this.setApplication((IApplication)Application.get());
        this.setProperties();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    IRootTabObjectInfo ip;
                    SqlCodeWizardDialog.WizardResult result = SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AttachDatabaseWizard(AttachDatabaseAction.this.getDatabase()), (boolean)true);
                    if (result != null && AttachDatabaseAction.this.getComponent() != null && (ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)AttachDatabaseAction.this.getComponent())) != null) {
                        ip.refresh((String)result.getResultMap().get("object_name"));
                    }
                }
                catch (Exception ex) {
                    MessageBox.show((String)AttachDatabaseAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                }
            }
        };
    }

    private void setProperties() {
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("AttachDatabaseAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/db_attach.gif"));
        this.setActionCommandKey("AttachDatabaseAction");
        this.addActionListener(this.createActionListener());
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"SQLite".equals(database.getDriverType())) {
            return false;
        }
        if (!"sqlite-databases-actions".equals(actionType)) {
            return false;
        }
        this.setProperties();
        return true;
    }

    public boolean isToolButton() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("AttachDatabaseAction-description");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

