/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DetachDatabaseAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (DetachDatabaseAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)DetachDatabaseAction.this.getComponent()).getSelectedRow() >= 0) {
                    IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)DetachDatabaseAction.this.getComponent());
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String catalogName = vt.getQuery().fieldByName("name").getString();
                        if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DetachDatabaseAction.this.stringManager.getString("detach"), (String)DetachDatabaseAction.this.stringManager.getString("DetachDatabaseAction-detach-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                            DetachDatabaseAction.this.getDatabase().executeCommand("DETACH DATABASE " + SQLUtil.createSqlName((String)catalogName));
                            ip.refresh();
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)DetachDatabaseAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"SQLite".equals(database.getDriverType())) {
            return false;
        }
        if (!"sqlite-databases-actions".equals(actionType)) {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("DetachDatabaseAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/db_detach.gif"));
        this.setActionCommandKey("DetachDatabaseAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public boolean isToolButton() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("DetachDatabaseAction-description");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

