/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropTriggerAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewTable vt;
                if (DropTriggerAction.this.getComponent() instanceof ViewTable && (vt = (ViewTable)DropTriggerAction.this.getComponent()).getSelectedRow() >= 0) {
                    try {
                        vt.getQuery().getRecord(vt.getSelectedRow());
                        String catalogName = vt.getQuery().fieldByName("database").getString();
                        String triggerName = vt.getQuery().fieldByName("name").getString();
                        if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropTriggerAction.this.stringManager.getString("deleting"), (String)DropTriggerAction.this.stringManager.getString("DropTriggerAction-drop-trigger-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                            DropTriggerAction.this.getDatabase().executeCommand("DROP TRIGGER " + SQLUtil.createSqlName((String)catalogName, (String)triggerName));
                            ITabObjectInfo trigt = (ITabObjectInfo)SwingUtil.getOwnerComponent(ITabObjectInfo.class, (Component)DropTriggerAction.this.getComponent());
                            if (trigt != null) {
                                trigt.refresh();
                            } else {
                                IRootTabObjectInfo trigvv = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)DropTriggerAction.this.getComponent());
                                if (trigvv != null) {
                                    trigvv.refresh(null);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        MessageBox.show((String)DropTriggerAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"SQLite".equals(database.getDriverType())) {
            return false;
        }
        if (!("sqlite-triggers-actions".equals(actionType) || "sqlite-table-triggers-actions".equals(actionType) || "sqlite-view-triggers-actions".equals(actionType))) {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("DropTriggerAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.setActionCommandKey("DropTriggerAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public boolean isToolButton() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("DropTriggerAction-description");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

