/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.sqlite.services.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.sqlite.OrbadaSQLitePlugin;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DropViewAction
extends ComponentActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaSQLitePlugin.class);

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DropViewAction.this.getComponent() instanceof ViewTable) {
                    ViewTable vt = (ViewTable)DropViewAction.this.getComponent();
                    IRootTabObjectInfo ip = (IRootTabObjectInfo)SwingUtil.getOwnerComponent(IRootTabObjectInfo.class, (Component)DropViewAction.this.getComponent());
                    if (vt.getSelectedRow() >= 0) {
                        try {
                            vt.getQuery().getRecord(vt.getSelectedRow());
                            String catalogName = vt.getQuery().fieldByName("database").getString();
                            String tableName = vt.getQuery().fieldByName("name").getString();
                            if (MessageBox.show((Component)SwingUtil.getRootFrame(), (String)DropViewAction.this.stringManager.getString("deleting"), (String)DropViewAction.this.stringManager.getString("DropViewAction-drop-view-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                                DropViewAction.this.getDatabase().executeCommand("DROP VIEW " + SQLUtil.createSqlName((String)catalogName, (String)tableName));
                                ip.refresh(null);
                            }
                        }
                        catch (Exception ex) {
                            MessageBox.show((String)DropViewAction.this.stringManager.getString("error"), (String)ex.getMessage(), (int)1);
                        }
                    }
                }
            }
        };
    }

    public boolean isForComponent(Database database, String actionType) {
        if (database == null || !"SQLite".equals(database.getDriverType())) {
            return false;
        }
        if (!"sqlite-views-actions".equals(actionType)) {
            return false;
        }
        this.setText(this.getDescription());
        this.setTooltip(this.stringManager.getString("DropViewAction-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.setActionCommandKey("DropViewAction");
        this.addActionListener(this.createActionListener());
        return true;
    }

    public boolean isToolButton() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("DropViewAction-description");
    }

    public String getGroupName() {
        return "SQLite";
    }
}

